/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.IgniteExternalizableExpiryPolicy;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.TxEntryValueHolder;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

@IgniteCodeGeneratingFail
public class IgniteTxEntry
implements GridPeerDeployAware,
Message {
    private static final long serialVersionUID = 0L;
    public static final GridCacheVersion SER_READ_EMPTY_ENTRY_VER = new GridCacheVersion(0, 0, 0L);
    public static final GridCacheVersion SER_READ_NOT_EMPTY_VER = new GridCacheVersion(0, 0, 1L);
    public static final GridCacheVersion GET_ENTRY_INVALID_VER_UPDATED = new GridCacheVersion(0, 0, 2L);
    public static final GridCacheVersion GET_ENTRY_INVALID_VER_AFTER_GET = new GridCacheVersion(0, 0, 3L);
    private static final int TX_ENTRY_SKIP_STORE_FLAG_MASK = 1;
    private static final int TX_ENTRY_KEEP_BINARY_FLAG_MASK = 2;
    private static final int TX_ENTRY_OLD_VAL_ON_PRIMARY = 4;
    private static final int TX_ENTRY_ADD_READER_FLAG_MASK = 8;
    private static final AtomicIntegerFieldUpdater<IgniteTxEntry> PREPARED_UPD = AtomicIntegerFieldUpdater.newUpdater(IgniteTxEntry.class, "prepared");
    @GridToStringExclude
    @GridDirectTransient
    private IgniteInternalTx tx;
    @GridToStringInclude
    private KeyCacheObject key;
    private int cacheId;
    @GridDirectTransient
    private IgniteTxKey txKey;
    @GridToStringInclude
    private TxEntryValueHolder val = new TxEntryValueHolder();
    @GridToStringInclude
    @GridDirectTransient
    private TxEntryValueHolder prevVal = new TxEntryValueHolder();
    @GridToStringInclude
    private TxEntryValueHolder oldVal = new TxEntryValueHolder();
    @GridToStringInclude
    @GridDirectTransient
    private Collection<T2<EntryProcessor<Object, Object, Object>, Object[]>> entryProcessorsCol;
    @GridDirectTransient
    private T2<GridCacheOperation, CacheObject> entryProcessorCalcVal;
    @GridToStringExclude
    private byte[] transformClosBytes;
    private long ttl;
    private long conflictExpireTime = -1L;
    private GridCacheVersion conflictVer;
    @GridToStringInclude
    private GridCacheVersion explicitVer;
    @GridDirectTransient
    private volatile GridCacheVersion dhtVer;
    @GridToStringInclude
    private CacheEntryPredicate[] filters;
    @GridDirectTransient
    private boolean filtersPassed;
    @GridDirectTransient
    private boolean filtersSet;
    @GridDirectTransient
    private volatile GridCacheEntryEx entry;
    @GridDirectTransient
    private GridCacheContext<?, ?> ctx;
    @GridDirectTransient
    private volatile transient int prepared;
    @GridDirectTransient
    private transient boolean locked;
    @GridDirectTransient
    private UUID nodeId;
    @GridDirectTransient
    private boolean locMapped;
    @GridDirectTransient
    private ExpiryPolicy expiryPlc;
    @GridDirectTransient
    private boolean transferExpiryPlc;
    private byte[] expiryPlcBytes;
    private byte flags;
    @GridDirectTransient
    private long partUpdateCntr;
    private GridCacheVersion serReadVer;

    public IgniteTxEntry() {
    }

    public IgniteTxEntry(GridCacheContext<?, ?> ctx, IgniteInternalTx tx, GridCacheOperation op, CacheObject val, long ttl, long conflictExpireTime, GridCacheEntryEx entry, @Nullable GridCacheVersion conflictVer, boolean skipStore, boolean keepBinary) {
        assert (ctx != null);
        assert (tx != null);
        assert (op != null);
        assert (entry != null);
        this.ctx = ctx;
        this.tx = tx;
        this.val.value(op, val, false, false);
        this.entry = entry;
        this.ttl = ttl;
        this.conflictExpireTime = conflictExpireTime;
        this.conflictVer = conflictVer;
        this.skipStore(skipStore);
        this.keepBinary(keepBinary);
        this.key = entry.key();
        this.cacheId = entry.context().cacheId();
    }

    public IgniteTxEntry(GridCacheContext<?, ?> ctx, IgniteInternalTx tx, GridCacheOperation op, CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, Object[] invokeArgs, long ttl, GridCacheEntryEx entry, CacheEntryPredicate[] filters, GridCacheVersion conflictVer, boolean skipStore, boolean keepBinary, boolean addReader) {
        assert (ctx != null);
        assert (tx != null);
        assert (op != null);
        assert (entry != null);
        this.ctx = ctx;
        this.tx = tx;
        this.val.value(op, val, false, false);
        this.entry = entry;
        this.ttl = ttl;
        this.filters = filters;
        this.conflictVer = conflictVer;
        this.skipStore(skipStore);
        this.keepBinary(keepBinary);
        this.addReader(addReader);
        if (entryProcessor != null) {
            this.addEntryProcessor(entryProcessor, invokeArgs);
        }
        this.key = entry.key();
        this.cacheId = entry.context().cacheId();
    }

    public GridCacheContext<?, ?> context() {
        return this.ctx;
    }

    public void context(GridCacheContext<?, ?> ctx) {
        this.ctx = ctx;
    }

    public boolean locallyMapped() {
        return this.locMapped;
    }

    public void locallyMapped(boolean locMapped) {
        this.locMapped = locMapped;
    }

    public IgniteTxEntry cleanCopy(GridCacheContext<?, ?> ctx) {
        IgniteTxEntry cp = new IgniteTxEntry();
        cp.key = this.key;
        cp.cacheId = this.cacheId;
        cp.ctx = ctx;
        cp.val = new TxEntryValueHolder();
        cp.filters = this.filters;
        cp.val.value(this.val.op(), this.val.value(), this.val.hasWriteValue(), this.val.hasReadValue());
        cp.entryProcessorsCol = this.entryProcessorsCol;
        cp.ttl = this.ttl;
        cp.conflictExpireTime = this.conflictExpireTime;
        cp.explicitVer = this.explicitVer;
        cp.conflictVer = this.conflictVer;
        cp.expiryPlc = this.expiryPlc;
        cp.flags = this.flags;
        cp.serReadVer = this.serReadVer;
        return cp;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public GridCacheVersion dhtVersion() {
        return this.dhtVer;
    }

    public void dhtVersion(GridCacheVersion dhtVer) {
        this.dhtVer = dhtVer;
    }

    public boolean locked() {
        return this.locked;
    }

    public void markLocked() {
        this.locked = true;
    }

    public void updateCounter(long partCntr) {
        this.partUpdateCntr = partCntr;
    }

    public long updateCounter() {
        return this.partUpdateCntr;
    }

    public void setAndMarkValid(CacheObject val) {
        this.setAndMarkValid(this.op(), val, this.val.hasWriteValue(), this.val.hasReadValue());
    }

    void setAndMarkValid(GridCacheOperation op, CacheObject val) {
        this.setAndMarkValid(op, val, this.val.hasWriteValue(), this.val.hasReadValue());
    }

    void setAndMarkValid(GridCacheOperation op, CacheObject val, boolean hasWriteVal, boolean hasReadVal) {
        this.val.value(op, val, hasWriteVal, hasReadVal);
        this.markValid();
    }

    public void markValid() {
        this.prevVal.value(this.val.op(), this.val.value(), this.val.hasWriteValue(), this.val.hasReadValue());
    }

    boolean markPrepared() {
        return PREPARED_UPD.compareAndSet(this, 0, 1);
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public void skipStore(boolean skipStore) {
        this.setFlag(skipStore, 1);
    }

    public boolean skipStore() {
        return this.isFlag(1);
    }

    public void oldValueOnPrimary(boolean oldValOnPrimary) {
        this.setFlag(oldValOnPrimary, 4);
    }

    boolean oldValueOnPrimary() {
        return this.isFlag(4);
    }

    public void keepBinary(boolean keepBinary) {
        this.setFlag(keepBinary, 2);
    }

    public boolean keepBinary() {
        return this.isFlag(2);
    }

    public void addReader(boolean addReader) {
        this.setFlag(addReader, 8);
    }

    public boolean addReader() {
        return this.isFlag(8);
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public IgniteTxKey txKey() {
        if (this.txKey == null) {
            this.txKey = new IgniteTxKey(this.key, this.cacheId);
        }
        return this.txKey;
    }

    public GridCacheEntryEx cached() {
        return this.entry;
    }

    public void cached(GridCacheEntryEx entry) {
        assert (entry == null || entry.context() == this.ctx) : "Invalid entry assigned to tx entry [txEntry=" + this + ", entry=" + entry + ", ctxNear=" + this.ctx.isNear() + ", ctxDht=" + this.ctx.isDht() + ']';
        this.entry = entry;
    }

    @Nullable
    public CacheObject value() {
        return this.val.value();
    }

    @Nullable
    public CacheObject oldValue() {
        return this.oldVal != null ? this.oldVal.value() : null;
    }

    public void oldValue(CacheObject oldVal) {
        if (this.oldVal == null) {
            this.oldVal = new TxEntryValueHolder();
        }
        this.oldVal.value(this.op(), oldVal, true, true);
    }

    public boolean hasOldValue() {
        return this.oldVal != null && this.oldVal.hasValue();
    }

    public boolean hasValue() {
        return this.val.hasValue();
    }

    public boolean hasWriteValue() {
        return this.val.hasWriteValue();
    }

    public boolean hasReadValue() {
        return this.val.hasReadValue();
    }

    @Nullable
    public CacheObject previousValue() {
        return this.prevVal.value();
    }

    boolean hasPreviousValue() {
        return this.prevVal.hasValue();
    }

    @Nullable
    public GridCacheOperation previousOperation() {
        return this.prevVal.op();
    }

    public long ttl() {
        return this.ttl;
    }

    public void ttl(long ttl) {
        this.ttl = ttl;
    }

    public long conflictExpireTime() {
        return this.conflictExpireTime;
    }

    public void conflictExpireTime(long conflictExpireTime) {
        this.conflictExpireTime = conflictExpireTime;
    }

    public void value(@Nullable CacheObject val, boolean writeVal, boolean readVal) {
        this.val.value(this.val.op(), val, writeVal, readVal);
    }

    public void readValue(@Nullable CacheObject val) {
        this.val.value(this.val.op(), val, false, true);
    }

    public void addEntryProcessor(EntryProcessor<Object, Object, Object> entryProcessor, Object[] invokeArgs) {
        if (this.entryProcessorsCol == null) {
            this.entryProcessorsCol = new LinkedList<T2<EntryProcessor<Object, Object, Object>, Object[]>>();
        }
        this.entryProcessorsCol.add(new T2<EntryProcessor<Object, Object, Object>, Object[]>(entryProcessor, invokeArgs));
        this.transformClosBytes = null;
        this.val.op(GridCacheOperation.TRANSFORM);
    }

    public Collection<T2<EntryProcessor<Object, Object, Object>, Object[]>> entryProcessors() {
        return this.entryProcessorsCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject applyEntryProcessors(CacheObject cacheVal) {
        GridCacheVersion ver;
        try {
            ver = this.entry.version();
        }
        catch (GridCacheEntryRemovedException ignore) {
            assert (this.tx == null || this.tx.optimistic()) : this.tx;
            ver = null;
        }
        Object val = null;
        Object keyVal = null;
        for (T2<EntryProcessor<Object, Object, Object>, Object[]> t : this.entryProcessors()) {
            IgniteThread.onEntryProcessorEntered(true);
            try {
                CacheInvokeEntry<Object, Object> invokeEntry = new CacheInvokeEntry<Object, Object>(this.key, keyVal, cacheVal, val, ver, this.keepBinary(), this.cached());
                EntryProcessor processor = (EntryProcessor)t.get1();
                processor.process(invokeEntry, (Object[])t.get2());
                val = invokeEntry.getValue();
                keyVal = invokeEntry.key();
            }
            catch (Exception exception) {}
            continue;
            finally {
                IgniteThread.onEntryProcessorLeft();
            }
        }
        return this.ctx.toCacheObject(val);
    }

    public void entryProcessors(@Nullable Collection<T2<EntryProcessor<Object, Object, Object>, Object[]>> entryProcessorsCol) {
        this.entryProcessorsCol = entryProcessorsCol;
        this.transformClosBytes = null;
    }

    public GridCacheOperation op() {
        return this.val.op();
    }

    public void op(GridCacheOperation op) {
        this.val.op(op);
    }

    public boolean isRead() {
        return this.op() == GridCacheOperation.READ;
    }

    public void explicitVersion(GridCacheVersion explicitVer) {
        this.explicitVer = explicitVer;
    }

    public GridCacheVersion explicitVersion() {
        return this.explicitVer;
    }

    @Nullable
    public GridCacheVersion conflictVersion() {
        return this.conflictVer;
    }

    public void conflictVersion(@Nullable GridCacheVersion conflictVer) {
        this.conflictVer = conflictVer;
    }

    public CacheEntryPredicate[] filters() {
        return this.filters;
    }

    public void filters(CacheEntryPredicate[] filters) {
        this.filters = filters;
    }

    public boolean filtersPassed() {
        return this.filtersPassed;
    }

    public void filtersPassed(boolean filtersPassed) {
        this.filtersPassed = filtersPassed;
    }

    public boolean filtersSet() {
        return this.filtersSet;
    }

    public void filtersSet(boolean filtersSet) {
        this.filtersSet = filtersSet;
    }

    public void marshal(GridCacheSharedContext<?, ?> ctx, boolean transferExpiry) throws IgniteCheckedException {
        if (this.filters != null) {
            for (CacheEntryPredicate p : this.filters) {
                if (p == null) continue;
                p.prepareMarshal(this.ctx);
            }
        }
        if (this.transformClosBytes == null && this.entryProcessorsCol != null) {
            this.transformClosBytes = CU.marshal(this.ctx, this.entryProcessorsCol);
        }
        if (transferExpiry) {
            this.transferExpiryPlc = this.expiryPlc != null && this.expiryPlc != this.ctx.expiry();
        }
        this.key.prepareMarshal(this.context().cacheObjectContext());
        this.val.marshal(this.context());
        if (this.transferExpiryPlc) {
            if (this.expiryPlcBytes == null) {
                this.expiryPlcBytes = CU.marshal(this.ctx, new IgniteExternalizableExpiryPolicy(this.expiryPlc));
            }
        } else {
            this.expiryPlcBytes = null;
        }
    }

    public void unmarshal(GridCacheSharedContext<?, ?> ctx, boolean near, ClassLoader clsLdr) throws IgniteCheckedException {
        if (this.ctx == null) {
            GridCacheContext<Object, Object> cacheCtx = ctx.cacheContext(this.cacheId);
            assert (cacheCtx != null) : "Failed to find cache context [cacheId=" + this.cacheId + ", readyTopVer=" + ctx.exchange().readyAffinityVersion() + ']';
            if (cacheCtx.isNear() && !near) {
                cacheCtx = cacheCtx.near().dht().context();
            } else if (!cacheCtx.isNear() && near) {
                cacheCtx = cacheCtx.dht().near().context();
            }
            this.ctx = cacheCtx;
        }
        if (this.transformClosBytes != null && this.entryProcessorsCol == null) {
            this.entryProcessorsCol = (Collection)U.unmarshal(ctx, this.transformClosBytes, U.resolveClassLoader(clsLdr, ctx.gridConfig()));
        }
        if (this.filters == null) {
            this.filters = CU.empty0();
        } else {
            for (CacheEntryPredicate p : this.filters) {
                if (p == null) continue;
                p.finishUnmarshal(ctx.cacheContext(this.cacheId), clsLdr);
            }
        }
        this.key.finishUnmarshal(this.context().cacheObjectContext(), clsLdr);
        this.val.unmarshal(this.ctx, clsLdr);
        if (this.expiryPlcBytes != null && this.expiryPlc == null) {
            this.expiryPlc = (ExpiryPolicy)U.unmarshal(ctx, this.expiryPlcBytes, U.resolveClassLoader(clsLdr, ctx.gridConfig()));
        }
    }

    public void expiry(@Nullable ExpiryPolicy expiryPlc) {
        this.expiryPlc = expiryPlc;
    }

    @Nullable
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    public T2<GridCacheOperation, CacheObject> entryProcessorCalculatedValue() {
        return this.entryProcessorCalcVal;
    }

    public void entryProcessorCalculatedValue(T2<GridCacheOperation, CacheObject> entryProcessorCalcVal) {
        assert (entryProcessorCalcVal != null);
        this.entryProcessorCalcVal = entryProcessorCalcVal;
    }

    @Nullable
    public GridCacheVersion entryReadVersion() {
        return this.serReadVer;
    }

    public void entryReadVersion(GridCacheVersion ver) {
        assert (this.serReadVer == null) : "Wrong version [serReadVer=" + this.serReadVer + ", ver=" + ver + "]";
        assert (ver != null);
        this.serReadVer = ver;
    }

    public void clearEntryReadVersion() {
        this.serReadVer = null;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("conflictExpireTime", this.conflictExpireTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("conflictVer", this.conflictVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("expiryPlcBytes", this.expiryPlcBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("explicitVer", this.explicitVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeObjectArray("filters", !F.isEmptyOrNulls(this.filters) ? this.filters : null, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeMessage("oldVal", this.oldVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("serReadVer", this.serReadVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeByteArray("transformClosBytes", this.transformClosBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeLong("ttl", this.ttl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.conflictExpireTime = reader.readLong("conflictExpireTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.conflictVer = (GridCacheVersion)reader.readMessage("conflictVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.expiryPlcBytes = reader.readByteArray("expiryPlcBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.explicitVer = (GridCacheVersion)reader.readMessage("explicitVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.filters = reader.readObjectArray("filters", MessageCollectionItemType.MSG, CacheEntryPredicate.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.oldVal = (TxEntryValueHolder)reader.readMessage("oldVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.serReadVer = (GridCacheVersion)reader.readMessage("serReadVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.transformClosBytes = reader.readByteArray("transformClosBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.ttl = reader.readLong("ttl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.val = (TxEntryValueHolder)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgniteTxEntry.class);
    }

    @Override
    public short directType() {
        return 100;
    }

    @Override
    public byte fieldsCount() {
        return 13;
    }

    @Override
    public Class<?> deployClass() {
        ClassLoader clsLdr = this.getClass().getClassLoader();
        CacheObject val = this.value();
        return this.key != null && !clsLdr.equals(this.key.getClass().getClassLoader()) ? this.key.getClass() : (val != null ? val.getClass() : this.getClass());
    }

    @Override
    public ClassLoader classLoader() {
        return this.deployClass().getClassLoader();
    }

    public String toString() {
        return GridToStringBuilder.toString(IgniteTxEntry.class, this, "xidVer", this.tx == null ? "null" : this.tx.xidVersion());
    }
}

