/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.DelayedDirtyPageStoreWrite;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;

public class DelayedPageReplacementTracker {
    private final int pageSize;
    private final PageStoreWriter flushDirtyPage;
    private final IgniteLogger log;
    private final Stripe[] stripes;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer buf = ByteBuffer.allocateDirect(DelayedPageReplacementTracker.this.pageSize);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            return buf;
        }
    };
    private final Map<Long, DelayedDirtyPageStoreWrite> delayedPageWriteThreadLocMap = new ConcurrentHashMap<Long, DelayedDirtyPageStoreWrite>();

    public DelayedPageReplacementTracker(int pageSize, PageStoreWriter flushDirtyPage, IgniteLogger log, int segmentCnt) {
        this.pageSize = pageSize;
        this.flushDirtyPage = flushDirtyPage;
        this.log = log;
        this.stripes = new Stripe[segmentCnt];
        for (int i = 0; i < this.stripes.length; ++i) {
            this.stripes[i] = new Stripe();
        }
    }

    public DelayedDirtyPageStoreWrite delayedPageWrite() {
        return this.delayedPageWriteThreadLocMap.computeIfAbsent(Thread.currentThread().getId(), id -> new DelayedDirtyPageStoreWrite(this.flushDirtyPage, this.byteBufThreadLoc, this.pageSize, this));
    }

    private Stripe stripe(FullPageId id) {
        int segmentIdx = PageMemoryImpl.segmentIndex(id.groupId(), id.pageId(), this.stripes.length);
        return this.stripes[segmentIdx];
    }

    public void lock(FullPageId id) {
        this.stripe(id).lock(id);
    }

    public void waitUnlock(FullPageId id) {
        this.stripe(id).waitUnlock(id);
    }

    public void unlock(FullPageId id) {
        this.stripe(id).unlock(id);
    }

    private class Stripe {
        private final Collection<FullPageId> locked = new HashSet<FullPageId>(Runtime.getRuntime().availableProcessors() * 2);
        private volatile boolean hasLockedPages;

        private Stripe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(FullPageId id) {
            Collection<FullPageId> collection = this.locked;
            synchronized (collection) {
                this.hasLockedPages = true;
                boolean add = this.locked.add(id);
                assert (add) : "Double locking of page for replacement is not possible";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUnlock(FullPageId id) {
            if (!this.hasLockedPages) {
                return;
            }
            Collection<FullPageId> collection = this.locked;
            synchronized (collection) {
                if (!this.hasLockedPages) {
                    return;
                }
                while (this.locked.contains(id)) {
                    if (DelayedPageReplacementTracker.this.log.isDebugEnabled()) {
                        DelayedPageReplacementTracker.this.log.debug("Found replaced page [" + id + "] which is being written to page store, wait for finish replacement");
                    }
                    try {
                        this.locked.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IgniteInterruptedException(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(FullPageId id) {
            Collection<FullPageId> collection = this.locked;
            synchronized (collection) {
                boolean rmv = this.locked.remove(id);
                assert (rmv) : "Unlocking page ID never locked, id " + id;
                if (this.locked.isEmpty()) {
                    this.hasLockedPages = false;
                }
                this.locked.notifyAll();
            }
        }
    }
}

