/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.terracotta.angela.common.AngelaProperties;

public class TerracottaCommandLineEnvironment {
    @Deprecated
    public static final Set<String> DEFAULT_ALLOWED_JDK_VENDORS = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList(AngelaProperties.JAVA_BUILD_VENDOR.getValue())));
    @Deprecated
    public static final String DEFAULT_JDK_VERSION = "1.8";
    public static final TerracottaCommandLineEnvironment DEFAULT = new TerracottaCommandLineEnvironment("1.8", DEFAULT_ALLOWED_JDK_VENDORS, Arrays.asList(AngelaProperties.JDK_SECURITY_ALLOW_NON_CA_ANCHOR.getJvmFormattedProperty()));
    private final String javaVersion;
    private final Set<String> javaVendors;
    private final List<String> javaOpts;

    public TerracottaCommandLineEnvironment(String javaVersion, Set<String> javaVendors, List<String> javaOpts) {
        this.javaVersion = javaVersion;
        this.javaVendors = javaVendors == null ? null : Collections.unmodifiableSet(new HashSet<String>(javaVendors));
        this.javaOpts = javaOpts == null ? null : Collections.unmodifiableList(new ArrayList<String>(javaOpts));
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public Set<String> getJavaVendors() {
        return this.javaVendors;
    }

    public List<String> getJavaOpts() {
        return this.javaOpts;
    }

    public TerracottaCommandLineEnvironment withJavaVersion(String javaVersion) {
        return new TerracottaCommandLineEnvironment(javaVersion, this.javaVendors, this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaVendors(Set<String> javaVendors) {
        return new TerracottaCommandLineEnvironment(this.javaVersion, javaVendors, this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaVendor(String javaVendor) {
        return new TerracottaCommandLineEnvironment(this.javaVersion, Collections.singleton(javaVendor), this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaOpts(List<String> javaOpts) {
        return new TerracottaCommandLineEnvironment(this.javaVersion, this.javaVendors, javaOpts);
    }

    public String toString() {
        return "TerracottaCommandLineEnvironment{javaVersion='" + this.javaVersion + '\'' + ", javaVendors=" + this.javaVendors + ", javaOpts=" + this.javaOpts + '}';
    }
}

