/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.util.IpUtils;

public enum AngelaProperties {
    ROOT_DIR("angela.rootDir", Paths.get("/data/angela", new String[0]).toAbsolutePath().toString()),
    KIT_INSTALLATION_DIR("angela.kitInstallationDir", null),
    DIRECT_JOIN("angela.directJoin", null),
    IGNITE_LOGGING("angela.igniteLogging", "false"),
    NODE_NAME("angela.nodeName", IpUtils.getHostName()),
    PORT_RANGE("angela.portRange", "1000"),
    SKIP_UNINSTALL("angela.skipUninstall", "false"),
    SSH_USERNAME("angela.ssh.userName", System.getProperty("user.name")),
    SSH_USERNAME_KEY_PATH("angela.ssh.userName.keyPath", null),
    SSH_STRICT_HOST_CHECKING("angela.ssh.strictHostKeyChecking", "true"),
    TMS_FULL_LOGGING("angela.tms.fullLogging", "false"),
    TSA_FULL_LOGGING("angela.tsa.fullLogging", "false"),
    JAVA_BUILD_VENDOR("angela.java.vendor", "zulu"),
    JDK_SECURITY_ALLOW_NON_CA_ANCHOR("jdk.security.allowNonCaAnchor", "false"),
    KITS_DIR("kitsDir", Paths.get("/data/angela", new String[0]).toAbsolutePath().toString()),
    KIT_INSTALLATION_PATH("kitInstallationPath", null);

    private static final Logger logger;
    private final String propertyName;
    private final String defaultValue;

    private AngelaProperties(String propertyName, String defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getSpecifiedValue() {
        return System.getProperty(this.propertyName);
    }

    public String getValue() {
        String specifiedValue = this.getSpecifiedValue();
        return specifiedValue == null || specifiedValue.isEmpty() ? this.getDefaultValue() : specifiedValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setProperty(String value) {
        System.setProperty(this.propertyName, value);
    }

    public void clearProperty() {
        System.clearProperty(this.propertyName);
    }

    public String getJvmFormattedProperty() {
        return "-D" + this.getPropertyName() + "=" + this.getValue();
    }

    public static String getEitherOf(AngelaProperties recommended, AngelaProperties deprecated) {
        String value = recommended.getSpecifiedValue();
        if (value == null && (value = deprecated.getSpecifiedValue()) != null) {
            logger.warn("Deprecated property '{}' specified. Use '{}' instead to be future-ready", (Object)deprecated.propertyName, (Object)recommended.propertyName);
        }
        if (value == null) {
            value = recommended.getDefaultValue();
        }
        return value;
    }

    static {
        logger = LoggerFactory.getLogger(AngelaProperties.class);
    }
}

