/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import java.io.Closeable;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.BasicAddressResolver;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.DirectoryUtils;
import org.terracotta.angela.common.util.HostAndIpValidator;
import org.terracotta.angela.common.util.HostPort;
import org.terracotta.angela.common.util.IgniteCommonHelper;
import org.terracotta.angela.common.util.IpUtils;

public class Agent {
    public static final String AGENT_IS_READY_MARKER_LOG = "Agent is ready";
    private static final Logger logger;
    public static final Path ROOT_DIR;
    public static final Path WORK_DIR;
    public static final Path IGNITE_DIR;
    public static volatile AgentController controller;

    public static void main(String[] args) {
        Node node = Agent.startNode();
        Runtime.getRuntime().addShutdownHook(new Thread(node::close));
    }

    static Node startNode() {
        String nodeName = AngelaProperties.NODE_NAME.getValue();
        String directJoin = AngelaProperties.DIRECT_JOIN.getValue();
        String portRange = AngelaProperties.PORT_RANGE.getValue();
        ArrayList<String> nodesToJoin = new ArrayList<String>();
        if (directJoin != null) {
            for (String node : directJoin.split(",")) {
                if (node.trim().isEmpty()) continue;
                nodesToJoin.add(node);
            }
        }
        Node node = new Node(nodeName, nodesToJoin, Integer.parseInt(portRange));
        System.out.println(AGENT_IS_READY_MARKER_LOG);
        System.out.flush();
        logger.debug("Agent started");
        return node;
    }

    static {
        System.setProperty("logback.configurationFile", "angela-logback.xml");
        logger = LoggerFactory.getLogger(Agent.class);
        ROOT_DIR = Paths.get(AngelaProperties.getEitherOf(AngelaProperties.ROOT_DIR, AngelaProperties.KITS_DIR), new String[0]);
        if (!ROOT_DIR.isAbsolute()) {
            throw new IllegalArgumentException("Expected ROOT_DIR to be an absolute path, got: " + ROOT_DIR);
        }
        WORK_DIR = ROOT_DIR.resolve("work");
        IGNITE_DIR = ROOT_DIR.resolve("ignite");
    }

    public static class Node
    implements Closeable {
        private volatile Ignite ignite;

        public Node(String nodeName, List<String> nodesToJoin) {
            this(nodeName, nodesToJoin, Integer.parseInt(AngelaProperties.PORT_RANGE.getDefaultValue()));
        }

        public Node(String nodeName, List<String> nodesToJoin, int portRange) {
            try {
                this.init(nodeName, nodesToJoin, portRange);
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception subEx) {
                    e.addSuppressed(subEx);
                }
                throw e;
            }
        }

        private void init(String nodeName, List<String> nodesToJoin, int portRange) {
            logger.info("Root directory is : " + ROOT_DIR);
            DirectoryUtils.createAndValidateDir(ROOT_DIR);
            DirectoryUtils.createAndValidateDir(WORK_DIR);
            DirectoryUtils.createAndValidateDir(IGNITE_DIR);
            IgniteConfiguration cfg = new IgniteConfiguration();
            cfg.setIgniteHome(IGNITE_DIR.resolve(System.getProperty("user.name")).toString());
            HashMap<String, String> userAttributes = new HashMap<String, String>();
            userAttributes.put("angela.version", AngelaVersion.getAngelaVersion());
            userAttributes.put("nodename", nodeName);
            cfg.setUserAttributes(userAttributes);
            if (!nodesToJoin.isEmpty()) {
                cfg.setIgniteInstanceName(nodeName);
            } else {
                cfg.setIgniteInstanceName("localhost");
            }
            boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
            cfg.setGridLogger(enableLogging ? new Slf4jLogger() : new NullLogger());
            cfg.setPeerClassLoadingEnabled(true);
            cfg.setMetricsLogFrequency(0L);
            if (nodesToJoin.isEmpty()) {
                logger.info("'{}' creating new isolated cluster", (Object)nodeName);
            } else {
                logger.info("'{}' joining isolated cluster on {}", (Object)nodeName, (Object)nodesToJoin);
            }
            ArrayList<String> nodesToJoinHostnames = new ArrayList<String>();
            HashMap<String, String> hostnameToIpMapping = new HashMap<String, String>();
            nodesToJoin.forEach(hostIpStr -> {
                String[] hostIp = hostIpStr.split("/");
                nodesToJoinHostnames.add(hostIp[0]);
                if (hostIp.length > 1) {
                    int lastColon = hostIp[0].lastIndexOf(":");
                    if (lastColon == -1 || HostAndIpValidator.isValidIPv6(hostIp[0])) {
                        hostnameToIpMapping.put(hostIp[0], hostIp[1]);
                    } else {
                        hostnameToIpMapping.put(hostIp[0].substring(0, lastColon), hostIp[1]);
                    }
                }
            });
            TcpDiscoverySpi spi = new TcpDiscoverySpi();
            spi.setIpFinder(new TcpDiscoveryVmIpFinder(true).setAddresses(nodesToJoinHostnames));
            spi.setLocalPort(40000);
            spi.setJoinTimeout(10000L);
            spi.setLocalPortRange(portRange);
            cfg.setCommunicationSpi(new TcpCommunicationSpi().setLocalPortRange(portRange));
            cfg.setDiscoverySpi(spi);
            if (!hostnameToIpMapping.isEmpty()) {
                logger.info("Adding address resolver for : " + hostnameToIpMapping);
                try {
                    cfg.setAddressResolver(new BasicAddressResolver(hostnameToIpMapping));
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
                cfg.setLocalHost(IpUtils.getHostName());
            }
            try {
                this.ignite = Ignition.start(cfg);
                IgniteCommonHelper.checkForDuplicateAgent(this.ignite, nodeName);
            }
            catch (IgniteException e) {
                throw new RuntimeException("Error starting agent " + nodeName, e);
            }
            controller = new AgentController(this.ignite, nodesToJoin.isEmpty() ? Collections.singleton(new HostPort(nodeName, 40000).getHostPort()) : nodesToJoin);
            logger.info("Registered node '" + nodeName + "'");
        }

        @Override
        public void close() {
            controller = null;
            if (this.ignite != null) {
                this.ignite.close();
                this.ignite = null;
            }
        }
    }
}

