/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtDetachedCacheEntry;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionImpl;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateResult;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.ResultType;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvccUpdateDataRow
extends MvccDataRow
implements MvccUpdateResult,
BPlusTree.TreeVisitorClosure<CacheSearchRow, CacheDataRow> {
    private static final int FIRST = 8;
    private static final int CHECK_VERSION = 16;
    private static final int LAST_COMMITTED_FOUND = 32;
    private static final int CAN_CLEANUP = 64;
    private static final int PRIMARY = 128;
    private static final int REMOVE_OR_LOCK = 256;
    private static final int NEED_HISTORY = 512;
    private static final int FAST_UPDATE = 1024;
    private static final int FAST_MISMATCH = 2048;
    private static final int DELETED = 4096;
    private static final int NEED_OLD_VALUE = 8192;
    private static final int NEED_PREV_VALUE = 16384;
    @GridToStringExclude
    private final GridCacheContext cctx;
    private ResultType res;
    @GridToStringExclude
    private int state;
    private List<MvccLinkAwareSearchRow> cleanupRows;
    private final MvccSnapshot mvccSnapshot;
    private CacheDataRow oldRow;
    @GridToStringExclude
    private long resCrd;
    @GridToStringExclude
    private long resCntr;
    private List<MvccLinkAwareSearchRow> histRows;
    @GridToStringExclude
    private CacheEntryPredicate filter;
    private CacheInvokeResult invokeRes;

    public MvccUpdateDataRow(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, int part, long expireTime, MvccSnapshot mvccSnapshot, MvccVersion newVer, @Nullable CacheEntryPredicate filter, boolean primary, boolean lockOnly, boolean needHist, boolean fastUpdate, boolean needOldVal, boolean needPrevValue) {
        super(key, val, ver, part, expireTime, cctx.cacheId(), mvccSnapshot, newVer);
        this.mvccSnapshot = mvccSnapshot;
        this.cctx = cctx;
        this.filter = filter;
        assert (!lockOnly || val == null);
        int flags = 8;
        if (primary) {
            flags |= 0x90;
        }
        if (primary && (lockOnly || val == null)) {
            flags |= 0x102;
        }
        if (needHist) {
            flags |= 0x200;
        }
        if (fastUpdate) {
            flags |= 0x400;
        }
        if (needOldVal) {
            flags |= 0x2000;
        }
        if (needPrevValue) {
            flags |= 0x4000;
        }
        this.setFlags(flags);
        this.keyAbsentBeforeFlag(primary);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int visit(BPlusTree<CacheSearchRow, CacheDataRow> tree, BPlusIO<CacheSearchRow> io, long pageAddr, int idx, IgniteWriteAheadLogManager wal) throws IgniteCheckedException {
        long cleanupVer;
        this.unsetFlags(4);
        RowLinkIO rowIo = (RowLinkIO)((Object)io);
        if (this.isFlagsSet(136)) {
            long lockCrd = rowIo.getMvccLockCoordinatorVersion(pageAddr, idx);
            long lockCntr = rowIo.getMvccLockCounter(pageAddr, idx);
            if ((lockCrd != this.mvccCoordinatorVersion() || lockCntr != this.mvccCounter()) && MvccUtils.isActive(this.cctx, lockCrd, lockCntr, this.mvccSnapshot)) {
                this.resCrd = lockCrd;
                this.resCntr = lockCntr;
                this.res = ResultType.LOCKED;
                return this.setFlags(1);
            }
        }
        MvccDataRow row = (MvccDataRow)tree.getRow(io, pageAddr, idx, (Object)CacheDataRowAdapter.RowData.LINK_WITH_HEADER);
        if (this.isFlagsSet(8)) {
            int rowOpCntr;
            long rowCntr;
            long rowCrd;
            boolean removed;
            boolean bl = removed = row.newMvccCoordinatorVersion() != 0L;
            if (removed) {
                rowCrd = row.newMvccCoordinatorVersion();
                rowCntr = row.newMvccCounter();
                rowOpCntr = row.newMvccOperationCounter();
            } else {
                rowCrd = row.mvccCoordinatorVersion();
                rowCntr = row.mvccCounter();
                rowOpCntr = row.mvccOperationCounter();
            }
            if (MvccUtils.compare(this.mvccSnapshot, rowCrd, rowCntr) == 0) {
                ResultType resultType = this.mvccOperationCounter() == rowOpCntr ? ResultType.VERSION_FOUND : (this.res = removed ? ResultType.PREV_NULL : ResultType.PREV_NOT_NULL);
                if (removed) {
                    this.setFlags(4096);
                } else {
                    this.oldRow = this.res == ResultType.PREV_NOT_NULL && (this.isFlagsSet(16384) || this.filter != null) ? tree.getRow(io, pageAddr, idx, (Object)CacheDataRowAdapter.RowData.FULL) : row;
                }
                if (this.filter != null && !this.applyFilter(this.res == ResultType.PREV_NOT_NULL ? this.oldRow.value() : null)) {
                    this.res = ResultType.FILTERED;
                }
                this.setFlags(32);
                if (this.isFlagsSet(128)) {
                    this.keyAbsentBeforeFlag(row.keyAbsentBeforeFlag());
                }
            }
        }
        long rowLink = row.link();
        long rowCrd = row.mvccCoordinatorVersion();
        long rowCntr = row.mvccCounter();
        int rowOpCntr = row.mvccTxState() << 30 | row.mvccOperationCounter() & 0x1FFFFFFF;
        long rowNewCrd = row.newMvccCoordinatorVersion();
        long rowNewCntr = row.newMvccCounter();
        int rowNewOpCntr = row.newMvccTxState() << 30 | row.newMvccOperationCounter() & 0x1FFFFFFF;
        if (!this.isFlagsSet(32)) {
            if (this.resCrd != rowCrd || this.resCntr != rowCntr) {
                byte txState = MvccUtils.state(this.cctx, rowCrd, rowCntr, rowOpCntr);
                if (txState == 3) {
                    this.setFlags(32);
                    if (rowNewCrd != 0L) {
                        txState = rowNewCrd == rowCrd && rowNewCntr == rowCntr ? (byte)3 : (rowNewCrd == this.resCrd && rowNewCntr == this.resCntr ? (byte)2 : (byte)MvccUtils.state(this.cctx, rowNewCrd, rowNewCntr, rowNewOpCntr));
                        if (txState != 3 && txState != 2) {
                            throw MvccUtils.unexpectedStateException(this.cctx, txState, rowNewCrd, rowNewCntr, rowNewOpCntr, this.mvccSnapshot);
                        }
                        if (txState == 3) {
                            this.setFlags(4096);
                        }
                    }
                    if (this.isFlagsSet(4096)) {
                        this.res = ResultType.PREV_NULL;
                    } else {
                        this.res = ResultType.PREV_NOT_NULL;
                        this.keyAbsentBeforeFlag(false);
                        if (this.isFlagsSet(16384) || this.isFlagsSet(8192) || this.filter != null) {
                            this.oldRow = tree.getRow(io, pageAddr, idx, (Object)CacheDataRowAdapter.RowData.NO_KEY);
                            this.oldRow.key(this.key);
                        } else {
                            this.oldRow = row;
                        }
                    }
                    if (this.isFlagsSet(16)) {
                        int opCntr;
                        long cntr;
                        long crdVer;
                        if (this.isFlagsSet(4096)) {
                            crdVer = rowNewCrd;
                            cntr = rowNewCntr;
                            opCntr = rowNewOpCntr;
                        } else {
                            crdVer = rowCrd;
                            cntr = rowCntr;
                            opCntr = rowOpCntr;
                        }
                        if (!MvccUtils.isVisible(this.cctx, this.mvccSnapshot, crdVer, cntr, opCntr, false)) {
                            if (!(!this.isFlagsSet(1024) || this.isFlagsSet(4096) && MvccUtils.isVisible(this.cctx, this.mvccSnapshot, rowCrd, rowCntr, rowOpCntr, false))) {
                                this.res = ResultType.PREV_NULL;
                                this.setFlags(2048);
                            } else {
                                this.resCrd = crdVer;
                                this.resCntr = cntr;
                                this.res = ResultType.VERSION_MISMATCH;
                                return this.setFlags(1);
                            }
                        }
                    }
                    if (this.filter != null && !this.applyFilter(this.res == ResultType.PREV_NOT_NULL ? this.oldRow.value() : null)) {
                        this.res = ResultType.FILTERED;
                    }
                    if (!this.isFlagsSet(4096) && this.isFlagsSet(384) && !this.isFlagsSet(2048)) {
                        rowIo.setMvccLockCoordinatorVersion(pageAddr, idx, this.mvccCoordinatorVersion());
                        rowIo.setMvccLockCounter(pageAddr, idx, this.mvccCounter());
                        this.setFlags(4);
                    }
                    this.unsetFlags(2);
                } else {
                    if (txState != 2) throw MvccUtils.unexpectedStateException(this.cctx, txState, rowCrd, rowCntr, rowOpCntr, this.mvccSnapshot);
                    this.resCrd = rowCrd;
                    this.resCntr = rowCntr;
                }
            }
        } else if (this.isFlagsSet(2048)) {
            assert (!this.isFlagsSet(64));
            assert (MvccUtils.mvccVersionIsValid(rowNewCrd, rowNewCntr, rowNewOpCntr));
            if (MvccUtils.isVisible(this.cctx, this.mvccSnapshot, rowNewCrd, rowNewCntr, rowNewOpCntr, false)) {
                this.unsetFlags(2048);
            } else if (MvccUtils.isVisible(this.cctx, this.mvccSnapshot, rowCrd, rowCntr, rowOpCntr, false)) {
                this.resCrd = rowCrd;
                this.resCntr = rowCntr;
                this.res = ResultType.VERSION_MISMATCH;
                return this.setFlags(1);
            }
        }
        if ((cleanupVer = this.mvccSnapshot.cleanupVersion()) > 0L && !this.isFlagsSet(64) && this.isFlagsSet(4128)) {
            assert (MvccUtils.mvccVersionIsValid(rowNewCrd, rowNewCntr, rowNewOpCntr));
            if (rowNewCrd < this.mvccCoordinatorVersion() || cleanupVer >= rowNewCntr) {
                this.setFlags(64);
            }
        }
        if (this.isFlagsSet(64) || !this.isFlagsSet(32)) {
            if (this.cleanupRows == null) {
                this.cleanupRows = new ArrayList<MvccLinkAwareSearchRow>();
            }
            this.cleanupRows.add(new MvccLinkAwareSearchRow(this.cacheId, this.key, rowCrd, rowCntr, rowOpCntr & 0x1FFFFFFF, rowLink));
            return this.unsetFlags(8);
        } else {
            if (this.isFlagsSet(512) && (row == this.oldRow || rowCrd == this.mvccCoordinatorVersion() && rowCntr == this.mvccCounter() || rowNewCrd == this.mvccCoordinatorVersion() && rowNewCntr == this.mvccCounter())) {
                if (this.histRows == null) {
                    this.histRows = new ArrayList<MvccLinkAwareSearchRow>();
                }
                this.histRows.add(new MvccLinkAwareSearchRow(this.cacheId, this.key, rowCrd, rowCntr, rowOpCntr & 0x1FFFFFFF, rowLink));
            }
            if (cleanupVer <= 0L || this.isFlagsSet(64) || !this.isFlagsSet(32) || rowCrd >= this.mvccCoordinatorVersion() && Long.compare(cleanupVer, rowCntr) < 0) return this.unsetFlags(8);
            this.setFlags(64);
        }
        return this.unsetFlags(8);
    }

    private boolean applyFilter(final CacheObject val0) {
        GridDhtDetachedCacheEntry e = new GridDhtDetachedCacheEntry(this.cctx, this.key){

            @Override
            @Nullable
            public CacheObject peekVisibleValue() {
                return val0;
            }
        };
        return this.filter.apply(e);
    }

    @Override
    public int state() {
        return this.state;
    }

    public CacheDataRow oldRow() {
        return this.oldRow;
    }

    @Override
    @NotNull
    public ResultType resultType() {
        return this.res == null ? this.defaultResult() : this.res;
    }

    @NotNull
    private ResultType defaultResult() {
        assert (this.res == null);
        this.res = this.filter != null && !this.applyFilter(null) ? ResultType.FILTERED : ResultType.PREV_NULL;
        return this.res;
    }

    public List<MvccLinkAwareSearchRow> cleanupRows() {
        return this.cleanupRows;
    }

    @Override
    public MvccVersion resultVersion() {
        switch (this.resultType()) {
            case VERSION_FOUND: 
            case PREV_NULL: {
                return new MvccVersionImpl(this.mvccCoordinatorVersion(), this.mvccCounter(), this.mvccOperationCounter());
            }
            case PREV_NOT_NULL: 
            case REMOVED_NOT_NULL: {
                return new MvccVersionImpl(this.oldRow.mvccCoordinatorVersion(), this.oldRow.mvccCounter(), this.oldRow.mvccOperationCounter());
            }
            case LOCKED: 
            case VERSION_MISMATCH: {
                assert (this.resCrd != 0L && this.resCntr != 0L);
                return new MvccVersionImpl(this.resCrd, this.resCntr, 0);
            }
            case FILTERED: {
                if (this.oldRow != null) {
                    return new MvccVersionImpl(this.oldRow.mvccCoordinatorVersion(), this.oldRow.mvccCounter(), this.oldRow.mvccOperationCounter());
                }
                return new MvccVersionImpl(this.mvccCoordinatorVersion(), this.mvccCounter(), this.mvccOperationCounter());
            }
        }
        throw new IllegalStateException("Unexpected result type: " + (Object)((Object)this.resultType()));
    }

    @Override
    public List<MvccLinkAwareSearchRow> history() {
        if (this.isFlagsSet(512) && this.histRows == null) {
            this.histRows = new ArrayList<MvccLinkAwareSearchRow>();
        }
        return this.histRows;
    }

    @Override
    public CacheObject newValue() {
        return this.val;
    }

    @Override
    public CacheObject oldValue() {
        assert (this.oldRow != null);
        return this.oldRow.value();
    }

    @Override
    public boolean isKeyAbsentBefore() {
        return this.keyAbsentBeforeFlag();
    }

    public void value(CacheObject val0) {
        this.val = val0;
    }

    public void invokeResult(CacheInvokeResult invokeRes) {
        this.invokeRes = invokeRes;
    }

    @Override
    public CacheInvokeResult invokeResult() {
        return this.invokeRes;
    }

    private boolean isFlagsSet(int flags) {
        return (this.state & flags) == flags;
    }

    private int setFlags(int flags) {
        return this.state |= flags;
    }

    private int unsetFlags(int flags) {
        return this.state &= ~flags;
    }

    public void resultType(ResultType type) {
        this.res = type;
    }

    @Override
    public String toString() {
        return S.toString(MvccUpdateDataRow.class, this, "super", super.toString());
    }
}

