/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentArchivedStorage;

public class SegmentCompressStorage {
    private volatile boolean interrupted;
    private final SegmentArchivedStorage segmentArchivedStorage;
    private volatile long lastCompressedIdx = -1L;

    private SegmentCompressStorage(SegmentArchivedStorage segmentArchivedStorage) {
        this.segmentArchivedStorage = segmentArchivedStorage;
        this.segmentArchivedStorage.addObserver(this::onSegmentArchived);
    }

    static SegmentCompressStorage buildCompressStorage(SegmentArchivedStorage segmentArchivedStorage) {
        SegmentCompressStorage storage = new SegmentCompressStorage(segmentArchivedStorage);
        segmentArchivedStorage.addObserver(storage::onSegmentArchived);
        return storage;
    }

    void lastCompressedIdx(long lastCompressedIdx) {
        this.lastCompressedIdx = lastCompressedIdx;
    }

    long lastCompressedIdx() {
        return this.lastCompressedIdx;
    }

    synchronized long nextSegmentToCompressOrWait() throws IgniteInterruptedCheckedException {
        long segmentToCompress = this.lastCompressedIdx + 1L;
        try {
            while (segmentToCompress > this.segmentArchivedStorage.lastArchivedAbsoluteIndex() && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        this.checkInterrupted();
        return segmentToCompress;
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    private void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change compressed idx");
        }
    }

    private synchronized void onSegmentArchived(long lastAbsArchivedIdx) {
        this.notifyAll();
    }
}

