/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.NearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;

public class GridNearTxFinishAndAckFuture
extends GridFutureAdapter<IgniteInternalTx>
implements NearTxFinishFuture {
    private final NearTxFinishFuture finishFut;

    GridNearTxFinishAndAckFuture(NearTxFinishFuture finishFut) {
        this.finishFut = finishFut;
    }

    @Override
    public boolean commit() {
        return this.finishFut.commit();
    }

    @Override
    public GridNearTxLocal tx() {
        return this.finishFut.tx();
    }

    @Override
    public void finish(final boolean commit, boolean clearThreadMap, boolean onTimeout) {
        this.finishFut.finish(commit, clearThreadMap, onTimeout);
        if (this.finishFut.commit()) {
            this.finishFut.listen(new IgniteInClosure<NearTxFinishFuture>(){

                @Override
                public void apply(final NearTxFinishFuture fut) {
                    GridNearTxLocal tx = fut.tx();
                    IgniteInternalFuture<Void> ackFut = null;
                    MvccQueryTracker tracker = tx.mvccQueryTracker();
                    MvccSnapshot mvccSnapshot = tx.mvccSnapshot();
                    if (tracker != null) {
                        ackFut = tracker.onDone(tx, commit);
                    } else if (mvccSnapshot != null) {
                        if (commit) {
                            ackFut = tx.context().coordinators().ackTxCommit(mvccSnapshot);
                        } else {
                            tx.context().coordinators().ackTxRollback(mvccSnapshot);
                        }
                    }
                    if (ackFut != null) {
                        ackFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                            @Override
                            public void apply(IgniteInternalFuture<Void> ackFut) {
                                Exception err = null;
                                try {
                                    fut.get();
                                    ackFut.get();
                                }
                                catch (Exception e) {
                                    err = e;
                                }
                                catch (Error e) {
                                    GridNearTxFinishAndAckFuture.this.onDone(e);
                                    throw e;
                                }
                                if (err != null) {
                                    GridNearTxFinishAndAckFuture.this.onDone(err);
                                } else {
                                    GridNearTxFinishAndAckFuture.this.onDone(fut.tx());
                                }
                            }
                        });
                    } else {
                        GridNearTxFinishAndAckFuture.this.finishWithFutureResult(fut);
                    }
                }
            });
        } else {
            this.finishFut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                @Override
                public void apply(IgniteInternalFuture fut) {
                    GridNearTxFinishAndAckFuture.this.finishWithFutureResult(fut);
                }
            });
        }
    }

    @Override
    public void onNodeStop(IgniteCheckedException e) {
        super.onDone(this.finishFut.tx(), e);
    }

    private void finishWithFutureResult(IgniteInternalFuture<IgniteInternalTx> fut) {
        try {
            this.onDone(fut.get());
        }
        catch (RuntimeException | IgniteCheckedException e) {
            this.onDone(e);
        }
        catch (Error e) {
            this.onDone(e);
            throw e;
        }
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxFinishAndAckFuture.class, this);
    }
}

