/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.ThreadPoolMXBean;

public class ThreadPoolMXBeanAdapter
implements ThreadPoolMXBean {
    private final ExecutorService exec;

    public ThreadPoolMXBeanAdapter(ExecutorService exec) {
        assert (exec != null);
        this.exec = exec;
    }

    @Override
    public int getActiveCount() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getActiveCount() : -1;
    }

    @Override
    public long getCompletedTaskCount() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getCompletedTaskCount() : -1L;
    }

    @Override
    public int getCorePoolSize() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getCorePoolSize() : -1;
    }

    @Override
    public int getLargestPoolSize() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getLargestPoolSize() : -1;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getMaximumPoolSize() : -1;
    }

    @Override
    public int getPoolSize() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getPoolSize() : -1;
    }

    @Override
    public long getTaskCount() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getTaskCount() : -1L;
    }

    @Override
    public int getQueueSize() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getQueue().size() : -1;
    }

    @Override
    public long getKeepAliveTime() {
        return this.exec instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.exec).getKeepAliveTime(TimeUnit.MILLISECONDS) : -1L;
    }

    @Override
    public boolean isShutdown() {
        return this.exec.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.exec.isTerminated();
    }

    @Override
    public boolean isTerminating() {
        return this.exec instanceof ThreadPoolExecutor && ((ThreadPoolExecutor)this.exec).isTerminating();
    }

    @Override
    public String getRejectedExecutionHandlerClass() {
        if (!(this.exec instanceof ThreadPoolExecutor)) {
            return "";
        }
        RejectedExecutionHandler hnd = ((ThreadPoolExecutor)this.exec).getRejectedExecutionHandler();
        return hnd == null ? "" : hnd.getClass().getName();
    }

    @Override
    public String getThreadFactoryClass() {
        if (!(this.exec instanceof ThreadPoolExecutor)) {
            return "";
        }
        ThreadFactory factory = ((ThreadPoolExecutor)this.exec).getThreadFactory();
        return factory == null ? "" : factory.getClass().getName();
    }

    public String toString() {
        return S.toString(ThreadPoolMXBeanAdapter.class, this, super.toString());
    }
}

