/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ternlang.dx.dex.code;

import org.ternlang.dx.rop.code.RegisterSpecList;
import org.ternlang.dx.rop.code.SourcePosition;
import org.ternlang.dx.util.AnnotatedOutput;

/*
 * Pseudo-instruction base class for zero-size (no code emitted)
 * instructions, which are generally used for tracking metainformation
 * about the code they are adjacent to.
 */
public abstract class ZeroSizeInsn extends DalvInsn {
    /*
     * Constructs an instance. The output address of this instance is initially
     * unknown ({@code -1}).
     *
     * @param position {@code non-null;} source position
     */
    public ZeroSizeInsn(SourcePosition position) {
        super(Dops.SPECIAL_FORMAT, position, RegisterSpecList.EMPTY);
    }

    /* {@inheritDoc} */
    @Override
    public final int codeSize() {
        return 0;
    }

    /* {@inheritDoc} */
    @Override
    public final void writeTo(AnnotatedOutput out) {
        // Nothing to do here, for this class.
    }

    /* {@inheritDoc} */
    @Override
    public final DalvInsn withOpcode(Dop opcode) {
        throw new RuntimeException("unsupported");
    }

    /* {@inheritDoc} */
    @Override
    public DalvInsn withRegisterOffset(int delta) {
        return withRegisters(getRegisters().withOffset(delta));
    }
}