/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.wizard;

import com.sun.javafx.application.PlatformImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.tentackle.common.InterruptedRuntimeException;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxUtilities;
import org.tentackle.maven.wizard.AbstractWizardMojo;
import org.tentackle.maven.wizard.OperationProfile;
import org.tentackle.maven.wizard.PackageInfo;
import org.tentackle.maven.wizard.fx.OperationWizard;

@Mojo(name="operation", inheritByDefault=false, aggregator=true)
public class OperationMojo
extends AbstractWizardMojo {
    private List<OperationProfile> operationProfiles;

    public List<OperationProfile> getOperationProfiles() {
        return this.operationProfiles;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        CountDownLatch latch = new CountDownLatch(1);
        PlatformImpl.startup(() -> {
            try {
                OperationWizard wizard = (OperationWizard)Fx.load(OperationWizard.class);
                wizard.applyMojo(this);
                Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
                Scene scene = new Scene(wizard.getView());
                stage.setScene(scene);
                stage.setTitle("Operation Wizard");
                wizard.getContainer().updateView();
                stage.setOnHidden(event -> latch.countDown());
                stage.show();
                FxUtilities.getInstance().addStyleSheets();
            }
            catch (Throwable t) {
                this.getLog().error(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException((Throwable)e);
        }
    }

    @Override
    protected void validate() throws MojoExecutionException {
        super.validate();
        this.operationProfiles = this.getProfiles(OperationProfile.class);
        if (this.operationProfiles.isEmpty()) {
            throw new MojoExecutionException("at least one OperationProfile must be configured");
        }
        Map<String, PackageInfo> packageInfoMap = this.createPackageMap();
        for (OperationProfile profile : this.operationProfiles) {
            profile.validate(packageInfoMap);
        }
    }
}

