/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.List;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCondition;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;

public class DataItem
implements DataNode {
    private final String type;
    private final String name;
    private final Object value;
    private final String comment;
    private final Entity entity;
    private final Attribute attribute;
    private final boolean idOfCompositeRelation;
    private final NonCompositeRelation nonCompositeRelation;
    private final SqlCondition sqlCondition;
    private String displayValue;
    private String configurationPath;

    public DataItem(String type, String name, Object value, String comment, Entity entity, Attribute attribute, boolean idOfCompositeRelation, NonCompositeRelation nonCompositeRelation, SqlCondition sqlCondition) {
        this.type = type;
        this.name = name;
        this.value = value;
        this.comment = comment;
        this.entity = entity;
        this.attribute = attribute;
        this.idOfCompositeRelation = idOfCompositeRelation;
        this.nonCompositeRelation = nonCompositeRelation;
        this.sqlCondition = sqlCondition;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return this.attribute != null && this.attribute.isHidden();
    }

    @Override
    public String getValue() {
        if (this.displayValue == null) {
            StringBuilder buf = new StringBuilder();
            if (this.value != null) {
                buf.append(this.value);
            }
            if (this.nonCompositeRelation != null) {
                if (!buf.isEmpty()) {
                    buf.append(' ');
                }
                buf.append("-> ").append(this.nonCompositeRelation);
            }
            this.displayValue = buf.toString();
        }
        return this.displayValue;
    }

    public Object getOrgValue() {
        return this.value;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public List<DataNode> getNodes() {
        return null;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public boolean isIdOfCompositeRelation() {
        return this.idOfCompositeRelation;
    }

    public NonCompositeRelation getNonCompositeRelation() {
        return this.nonCompositeRelation;
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Override
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    @Override
    public SqlCondition getSqlCondition() {
        return this.sqlCondition;
    }

    public boolean isCounterForListRelation() {
        if (this.attribute != null) {
            for (Relation relation : this.attribute.getEntity().getRelations()) {
                if (!this.attribute.equals((Object)relation.getCountAttribute())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKey() {
        return this.attribute != null && this.attribute.getOptions().isDomainKey();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type).append(' ').append(this.name).append(" = ");
        if (this.value == null) {
            buf.append("<null>");
        } else {
            buf.append("'").append(this.value).append("'");
        }
        return buf.toString();
    }
}

