/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.tentackle.fx.Fx;
import org.tentackle.maven.plugin.wizard.fx.TypeInfo;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCodeFactory;
import org.tentackle.model.ModelException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.sql.DataType;

public class PdoBrowserUtils {
    public static TypeInfo getTypeInfo(DataNode dataNode) {
        DataObject object;
        PersistentDomainObject<?> pdo;
        if (dataNode instanceof DataObject && (pdo = (object = (DataObject)dataNode).getPdo()) != null) {
            return new TypeInfo(pdo.getEffectiveClass().getName(), pdo.getTableName(), pdo.getClassId());
        }
        return null;
    }

    public static boolean isCreatingSqlPossible(DataNode dataNode) {
        if (dataNode != null) {
            block6: {
                DataObject dataObject;
                if (dataNode instanceof DataItem) {
                    DataItem dataItem = (DataItem)dataNode;
                    try {
                        DataType dataType = dataItem.getAttribute().getEffectiveDataType();
                        if (dataType.isColumnCountBackendSpecific() || dataType.getColumnCount(null) > 1) {
                            return false;
                        }
                        break block6;
                    }
                    catch (ModelException mx) {
                        return false;
                    }
                }
                if (dataNode instanceof DataObject && (dataObject = (DataObject)dataNode).getEntity().isEmbedded()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void copyToClipboard(String text) {
        ClipboardContent cbc = new ClipboardContent();
        cbc.putString(text);
        Clipboard.getSystemClipboard().setContent((Map)cbc);
    }

    public static MenuItem createCopySqlItem(EventHandler<ActionEvent> handler) {
        MenuItem copySqlItem = (MenuItem)Fx.create(MenuItem.class);
        copySqlItem.setOnAction(handler);
        copySqlItem.setText("copy SQL SELECT... to clipboard");
        return copySqlItem;
    }

    public static void configureContextMenu(DataNode dataNode, MenuItem copyFQCNItem, MenuItem copyTableItem, MenuItem copyClassIdItem, MenuItem copySqlItem) {
        TypeInfo typeInfo = PdoBrowserUtils.getTypeInfo(dataNode);
        copyFQCNItem.setVisible(false);
        copyTableItem.setVisible(false);
        copyClassIdItem.setVisible(false);
        copySqlItem.setVisible(PdoBrowserUtils.isCreatingSqlPossible(dataNode));
        if (typeInfo != null) {
            if (typeInfo.fqcn() != null) {
                copyFQCNItem.setText("copy FQCN \"" + typeInfo.fqcn() + "\" to clipboard");
                copyFQCNItem.setVisible(true);
            }
            if (typeInfo.tableName() != null) {
                copyTableItem.setText("copy table name \"" + typeInfo.tableName().replace("_", "__") + "\" to clipboard");
                copyTableItem.setMnemonicParsing(false);
                copyTableItem.setVisible(true);
            }
            if (typeInfo.classId() != 0L) {
                copyClassIdItem.setText("copy class-ID \"" + typeInfo.classId() + "\" to clipboard");
                copyClassIdItem.setVisible(true);
            }
        }
    }

    public static void copyFQCN(DataNode dataNode) {
        TypeInfo typeInfo = PdoBrowserUtils.getTypeInfo(dataNode);
        if (typeInfo != null) {
            PdoBrowserUtils.copyToClipboard(typeInfo.fqcn());
        }
    }

    public static void copyTableName(DataNode dataNode) {
        TypeInfo typeInfo = PdoBrowserUtils.getTypeInfo(dataNode);
        if (typeInfo != null) {
            PdoBrowserUtils.copyToClipboard(typeInfo.tableName());
        }
    }

    public static void copyClassId(DataNode dataNode) {
        TypeInfo typeInfo = PdoBrowserUtils.getTypeInfo(dataNode);
        if (typeInfo != null) {
            PdoBrowserUtils.copyToClipboard(Long.toString(typeInfo.classId()));
        }
    }

    public static void copySql(DataNode dataNode) {
        if (dataNode != null) {
            PdoBrowserUtils.copyToClipboard(SqlCodeFactory.createSelect(dataNode));
        }
    }

    private PdoBrowserUtils() {
    }
}

