/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javafx.application.Platform;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.bind.Bindable;
import org.tentackle.common.Timestamp;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.NotificationBuilder;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.FxComboBox;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.component.Note;
import org.tentackle.fx.container.FxBorderPane;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.container.FxSplitPane;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.maven.plugin.wizard.BrowseMojo;
import org.tentackle.maven.plugin.wizard.PdoProfile;
import org.tentackle.maven.plugin.wizard.fx.JavaCodeFactorySettings;
import org.tentackle.maven.plugin.wizard.fx.PdoBrowserUtils;
import org.tentackle.maven.plugin.wizard.fx.PdoType;
import org.tentackle.maven.plugin.wizard.fx.PdoView;
import org.tentackle.maven.plugin.wizard.pdodata.DataDiff;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataList;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataNodeFactory;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.JavaCodeFactory;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.maven.plugin.wizard.pdodata.PdoWrapper;
import org.tentackle.misc.FormatHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.PersistentDomainObject;

@FxControllerService(resources="NONE")
public class PdoBrowser
extends AbstractFxController
implements DomainContextProvider {
    private static final int LATEST_DEFAULT = 100;
    private static final double OUTER_DIVIDER_POSITION = 0.84;
    private static final String POPUP_CSS = "-fx-font-weight: bold; -fx-font-size: 16;";
    @Bindable
    private int latest = 100;
    @Bindable
    private PdoProfile profile;
    @Bindable
    private boolean rootOnly;
    @Bindable
    private PdoType entity;
    @Bindable
    private List<PdoWrapper> pdos;
    @FXML
    private FxSplitPane outerSplitPane;
    @FXML
    private FxSplitPane innerSplitPane;
    @FXML
    private FxChoiceBox<PdoProfile> profileField;
    @FXML
    private FxCheckBox rootOnlyField;
    @FXML
    private FxComboBox<PdoType> entityField;
    @FXML
    private FxTableView<PdoWrapper> pdosTableView;
    @FXML
    private FxTextField latestField;
    @FXML
    private FxButton refreshButton;
    @FXML
    private FxButton finderButton;
    @FXML
    private FxButton byIdButton;
    @FXML
    private FxButton configCodeButton;
    @FXML
    private FxButton configPathsButton;
    @FXML
    private FxButton generateButton;
    @FXML
    private FxButton memorizeButton;
    @FXML
    private FxButton closeButton;
    private BrowseMojo mojo;
    private DomainContext context;
    private TablePopup<PdoWrapper> pdosTablePopup;
    private DataObject dataObject;
    private DataObject oldDataObject;
    private PdoView pdoView;
    private TableView<DataNode> rowDetailsTable;
    private Timestamp loadingTime;
    private Timestamp memorizeTime;
    private PdoFinder finder;
    private Map<String, Boolean> codePaths;

    public static Stage show(BrowseMojo mojo, DomainContext context) throws MojoExecutionException {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        PdoBrowser diffDialog = (PdoBrowser)Fx.load(PdoBrowser.class);
        Scene scene = Fx.createScene((Parent)diffDialog.getView());
        stage.setScene(scene);
        stage.setTitle("PDO Browser");
        diffDialog.setContext(mojo, context);
        diffDialog.getContainer().updateView();
        Fx.show((Stage)stage);
        return stage;
    }

    @FXML
    private void initialize() {
        this.pdoView = (PdoView)Fx.load(PdoView.class);
        this.pdoView.addSelectedItemListener((ChangeListener<TreeItem<DataDiff>>)((ChangeListener)(observable, oldValue, newValue) -> this.updateRowDetails(newValue == null ? null : (DataDiff)newValue.getValue())));
        this.innerSplitPane.getItems().add((Object)this.pdoView.getView());
        this.rowDetailsTable = (TableView)Fx.create(TableView.class);
        MenuItem copyFQCNItem = (MenuItem)Fx.create(MenuItem.class);
        copyFQCNItem.setOnAction(e -> PdoBrowserUtils.copyFQCN(this.getSelectedDetailDataNode()));
        MenuItem copyTableItem = (MenuItem)Fx.create(MenuItem.class);
        copyTableItem.setOnAction(e -> PdoBrowserUtils.copyTableName(this.getSelectedDetailDataNode()));
        MenuItem copyClassIdItem = (MenuItem)Fx.create(MenuItem.class);
        copyClassIdItem.setOnAction(e -> PdoBrowserUtils.copyClassId(this.getSelectedDetailDataNode()));
        MenuItem copySqlItem = PdoBrowserUtils.createCopySqlItem((EventHandler<ActionEvent>)((EventHandler)e -> PdoBrowserUtils.copySql(this.getSelectedDetailDataNode())));
        MenuItem genCodeItem = (MenuItem)Fx.create(MenuItem.class);
        genCodeItem.setOnAction(e -> {
            DataNode node = this.getSelectedDetailDataNode();
            if (node instanceof DataObject) {
                DataObject dataObj = (DataObject)node;
                PdoBrowserUtils.copyToClipboard(JavaCodeFactory.generateCode(null, dataObj));
            }
        });
        genCodeItem.setText("copy Java code to clipboard");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{copyFQCNItem, copyTableItem, copyClassIdItem, copySqlItem, genCodeItem});
        contextMenu.addEventHandler(WindowEvent.WINDOW_SHOWING, event -> {
            genCodeItem.setVisible(this.getSelectedDetailDataNode() instanceof DataObject);
            PdoBrowserUtils.configureContextMenu(this.getSelectedDetailDataNode(), copyFQCNItem, copyTableItem, copyClassIdItem, copySqlItem);
        });
        this.rowDetailsTable.getSelectionModel().selectedItemProperty().addListener((obs, old, current) -> this.rowDetailsTable.setContextMenu(current == null ? null : contextMenu));
        this.outerSplitPane.getItems().add(this.rowDetailsTable);
        this.profileField.addViewToModelListener(this::updateEntityFieldProperties);
        this.rootOnlyField.addViewToModelListener(this::updateEntityFieldProperties);
        this.entityField.setListenerSuppressedIfModelUnchanged(true);
        this.entityField.setVisibleRowCount(25);
        this.entityField.addViewToModelListener(() -> this.run(new long[0]));
        this.latestField.addViewToModelListener(() -> {
            this.finder = null;
            this.run(new long[0]);
        });
        this.refreshButton.setGraphic(Fx.createGraphic((String)"reload"));
        this.refreshButton.setDisable(true);
        this.refreshButton.setOnAction(e -> this.run(new long[0]));
        this.byIdButton.setGraphic(Fx.createGraphic((String)"id"));
        this.byIdButton.setDisable(true);
        this.byIdButton.setOnAction(e -> this.loadById());
        this.finderButton.setGraphic(Fx.createGraphic((String)"search"));
        this.finderButton.setDisable(true);
        this.memorizeButton.setGraphic(Fx.createGraphic((String)"copy"));
        this.memorizeButton.setDisable(true);
        this.memorizeButton.setOnAction(event -> {
            this.oldDataObject = this.dataObject;
            this.memorizeTime = new Timestamp();
            this.showDiff();
        });
        this.configCodeButton.setGraphic(Fx.createGraphic((String)"preferences"));
        this.configCodeButton.setOnAction(e -> JavaCodeFactorySettings.show(this.getView()));
        this.configPathsButton.setGraphic(Fx.createGraphic((String)"tree"));
        this.configPathsButton.setOnAction(e -> this.editCodePaths());
        this.configPathsButton.setDisable(true);
        this.generateButton.setGraphic(Fx.createGraphic((String)"generate"));
        this.generateButton.setDisable(true);
        this.generateButton.setOnAction(e -> this.generateCode());
        this.closeButton.setGraphic(Fx.createGraphic((String)"close"));
        this.closeButton.setOnAction(this::close);
        this.pdosTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.pdosTableView.getSelectionModel().getSelectedItems().addListener(c -> {
            ObservableList selectedItems = c.getList();
            if (selectedItems.isEmpty()) {
                this.dataObject = null;
                this.oldDataObject = null;
                this.memorizeTime = null;
                this.codePaths = null;
                this.configPathsButton.setDisable(true);
                this.generateButton.setDisable(true);
                this.memorizeButton.setDisable(true);
                this.showDiff();
            } else {
                this.dataObject = ((PdoWrapper)selectedItems.get(0)).getDataObject();
                this.memorizeButton.setDisable(false);
                this.generateButton.setDisable(false);
                this.updateCodeConfiguration((List<? extends PdoWrapper>)selectedItems);
                this.showDiff();
            }
        });
    }

    public void configure() {
        this.pdosTableView.getConfiguration().setSortingIncluded(true);
        this.pdosTablePopup = Rdc.createTablePopup(this.pdosTableView, (String)"pdoView", (String)"PDOs");
        this.pdosTablePopup.setColumnMenuEnabled(false);
        this.pdosTablePopup.loadPreferences();
        double leftWidth = this.pdosTableView.getPrefWidth();
        double totalWidth = this.pdosTableView.getPrefWidth() + this.pdoView.getPrefWidth();
        if (leftWidth >= 1.0 && totalWidth > leftWidth) {
            this.innerSplitPane.setDividerPosition(0, leftWidth / totalWidth);
        }
        this.outerSplitPane.setPrefHeight(this.pdosTableView.getPrefHeight() / 0.84);
        this.outerSplitPane.setDividerPosition(0, 0.84);
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public void setContext(BrowseMojo mojo, DomainContext context) throws MojoExecutionException {
        this.mojo = mojo;
        this.context = context;
        this.profileField.getItems().setAll(mojo.getProfiles(PdoProfile.class));
        this.updateEntityFieldProperties();
        this.entityField.requestFocus();
        this.showDiff();
    }

    private void updateRowDetails(DataDiff diffNode) {
        this.rowDetailsTable.getColumns().clear();
        if (diffNode != null) {
            DataNode dataNode = diffNode.getLeft();
            Objects.requireNonNull(dataNode);
            DataNode dataNode2 = dataNode;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataObject.class, DataList.class, DataItem.class}, (Object)dataNode2, n)) {
                case 0: {
                    DataObject dataObj = (DataObject)dataNode2;
                    this.showDataObjects(List.of(dataObj));
                    break;
                }
                case 1: {
                    DataList dataList = (DataList)dataNode2;
                    this.showDataObjects(dataList.getNodes());
                    break;
                }
                case 2: {
                    DataItem dataItem = (DataItem)dataNode2;
                    this.showDataItem(dataItem);
                    break;
                }
            }
        }
    }

    private void showDataItem(DataItem dataItem) {
        NonCompositeRelation nonCompositeRelation = dataItem.getNonCompositeRelation();
        if (nonCompositeRelation != null) {
            this.showDataObjects(List.of(DataNodeFactory.create(nonCompositeRelation.getRelatedPdo())));
        }
    }

    private void showDataObjects(List<DataObject> dataObjects) {
        if (!dataObjects.isEmpty()) {
            int columnCount = 0;
            for (DataNode node : dataObjects.get(0).getNodes()) {
                int columnIndex = columnCount++;
                TableColumn column = new TableColumn(node.getName());
                column.setCellValueFactory(callback -> new StringPropertyBase(this, (TableColumn.CellDataFeatures)callback, node, columnIndex){
                    final /* synthetic */ TableColumn.CellDataFeatures val$callback;
                    final /* synthetic */ DataNode val$node;
                    final /* synthetic */ int val$columnIndex;
                    {
                        this.val$callback = cellDataFeatures;
                        this.val$node = dataNode;
                        this.val$columnIndex = n;
                    }

                    public DataNode getBean() {
                        return (DataNode)this.val$callback.getValue();
                    }

                    public String getName() {
                        return this.val$node.getName();
                    }

                    public String getValue() {
                        return this.getBean().getNodes().get(this.val$columnIndex).getValue();
                    }
                });
                this.rowDetailsTable.getColumns().add((Object)column);
            }
            this.rowDetailsTable.getItems().setAll(dataObjects);
        }
    }

    private void updateCodeConfiguration(List<? extends PdoWrapper> selectedItems) {
        this.codePaths = new LinkedHashMap<String, Boolean>();
        for (PdoWrapper pdoWrapper : selectedItems) {
            this.codePaths.putAll(pdoWrapper.getCodeConfiguration());
        }
        this.configPathsButton.setDisable(this.codePaths.isEmpty());
    }

    private void showDiff() {
        if (this.dataObject != null) {
            this.pdoView.setDiff(DataDiff.compare(this.dataObject, this.oldDataObject), this.loadingTime == null ? "Value" : FormatHelper.formatTimestamp((Date)this.loadingTime), this.memorizeTime == null ? "" : FormatHelper.formatTimestamp((Date)this.memorizeTime));
        } else {
            this.pdoView.setDiff(null, "Value", "");
        }
    }

    private void updateEntityFieldProperties() {
        this.entityField.getProperties().put((Object)"rootOnly", (Object)this.rootOnly);
        this.entityField.getProperties().put((Object)"profile", (Object)this.profile);
        this.entityField.getProperties().put((Object)"prefixSelectionEnabled", (Object)"CamelCase");
        Platform.runLater(() -> ((ValueTranslator)this.entityField.getValueTranslator()).bindingPropertiesUpdated());
    }

    private void run(long ... ids) {
        PdoWrapper selectedItem = (PdoWrapper)this.pdosTableView.getSelectionModel().getSelectedItem();
        DataObject savedOldDataObject = this.oldDataObject;
        Timestamp savedMemorizedTime = this.memorizeTime;
        this.pdosTableView.getSelectionModel().clearSelection();
        this.loadingTime = new Timestamp();
        if (this.entity != null) {
            PersistentDomainObject proxy = this.on(this.entity.getClazz());
            if (this.finder != null && this.finder.getPdo().getEffectiveClass() != this.entity.getClazz()) {
                this.finder = null;
            }
            if (ids.length > 0) {
                ArrayList<PdoWrapper> pdoList = ids[0] == 0L ? new ArrayList<PdoWrapper>() : new ArrayList<PdoWrapper>(this.pdos);
                HashSet<PdoWrapper> pdoSet = new HashSet<PdoWrapper>(pdoList);
                int insertIndex = 0;
                for (long id : ids) {
                    PdoWrapper pdoWrapper;
                    PersistentDomainObject pdo = proxy.on().select(id);
                    if (pdo == null || !pdoSet.add(pdoWrapper = new PdoWrapper(pdo))) continue;
                    pdoList.add(insertIndex++, pdoWrapper);
                }
                this.pdos = pdoList;
                Note infoNote = (Note)Fx.create(Note.class);
                infoNote.setPosition(Note.Position.TOP);
                infoNote.setText(insertIndex + " PDOs loaded");
                infoNote.setFadeEffect(500L, 2000L, 1000L);
                infoNote.show((Node)this.byIdButton);
            } else if (this.finder == null) {
                this.pdos = proxy.selectLatest(0L, this.latest).stream().map(PdoWrapper::new).toList();
            }
            this.refreshButton.setDisable(false);
            this.byIdButton.setDisable(false);
            GuiProvider<?> guiProvider = this.getGuiProvider(proxy);
            if (guiProvider != null && guiProvider.isFinderAvailable()) {
                this.finderButton.setDisable(false);
                this.finderButton.setOnAction(event -> {
                    this.finder = guiProvider.createFinder();
                    this.finder.setPdo(proxy);
                    Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
                    FxBorderPane borderPane = (FxBorderPane)Fx.create(BorderPane.class);
                    borderPane.setPadding(new Insets(10.0));
                    borderPane.setCenter((Node)this.finder.getView());
                    FxHBox hBox = (FxHBox)Fx.create(HBox.class);
                    hBox.setSpacing(10.0);
                    hBox.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
                    hBox.setAlignment(Pos.BASELINE_RIGHT);
                    FxButton cancelButton = (FxButton)Fx.create(Button.class);
                    cancelButton.setText("cancel");
                    cancelButton.setGraphic(Fx.createGraphic((String)"cancel"));
                    cancelButton.setOnAction(e -> {
                        stage.close();
                        this.finder = null;
                        this.run(new long[0]);
                    });
                    FxButton findButton = (FxButton)Fx.create(Button.class);
                    findButton.setText("find");
                    findButton.setGraphic(Fx.createGraphic((String)"search"));
                    findButton.setOnAction(e -> {
                        this.pdos = this.finder.runSearch().stream().map(pdo -> new PdoWrapper((PersistentDomainObject)pdo)).toList();
                        this.pdosTableView.updateView();
                        stage.close();
                    });
                    hBox.getChildren().addAll((Object[])new Node[]{findButton, cancelButton});
                    borderPane.setBottom((Node)hBox);
                    Scene scene = Fx.createScene((Parent)borderPane);
                    stage.setScene(scene);
                    stage.setTitle("Find " + proxy.getPlural());
                    borderPane.updateView();
                    Fx.show((Stage)stage);
                });
            } else {
                this.finderButton.setDisable(true);
            }
        } else {
            this.pdos = new ArrayList<PdoWrapper>();
            this.refreshButton.setDisable(true);
            this.finderButton.setDisable(true);
            this.finder = null;
        }
        this.pdosTableView.updateView();
        if (selectedItem != null && this.pdos.contains(selectedItem)) {
            this.oldDataObject = savedOldDataObject;
            this.memorizeTime = savedMemorizedTime;
            this.pdosTableView.getSelectionModel().select((Object)selectedItem);
        }
    }

    private void loadById() {
        BorderPane borderPane = (BorderPane)Fx.create(BorderPane.class);
        HBox hBox = (HBox)Fx.create(HBox.class);
        hBox.setPadding(new Insets(10.0));
        FxTextArea textField = (FxTextArea)Fx.create(TextArea.class);
        textField.setWrapText(true);
        textField.setPrefWidth(500.0);
        textField.setPrefHeight(200.0);
        textField.setNavigateViaEnterEnabled(false);
        hBox.getChildren().add((Object)textField);
        borderPane.setCenter((Node)hBox);
        Label headerLabel = (Label)Fx.create(Label.class);
        headerLabel.setText("Enter IDs (first 0 to clear)");
        headerLabel.setStyle(POPUP_CSS);
        BorderPane.setAlignment((Node)headerLabel, (Pos)Pos.CENTER);
        borderPane.setTop((Node)headerLabel);
        Button loadButton = (Button)Fx.create(Button.class);
        loadButton.setText("load");
        Popup popup = new Popup();
        Parent notification = FxFactory.getInstance().createNotificationBuilder().content((Node)borderPane).button(loadButton, false, () -> this.performLoadById(textField.getText())).closeButton(NotificationBuilder.CloseButtonMode.ALWAYS).hide(() -> ((Popup)popup).hide()).build();
        FxUtilities.getInstance().showNotification((Object)this.getView(), popup, notification, null);
    }

    private void performLoadById(String idString) {
        StringTokenizer stok = new StringTokenizer(idString, " ,:;/\t\n\r\f");
        ArrayList<Long> idList = new ArrayList<Long>();
        while (stok.hasMoreTokens()) {
            String idStr = stok.nextToken();
            try {
                idList.add(Long.valueOf(idStr));
            }
            catch (NumberFormatException nx) {
                Fx.warning((Object)this.getView(), (String)(idStr + " is not a number"));
            }
        }
        long[] idArgs = new long[idList.size()];
        int i = 0;
        for (Long id : idList) {
            idArgs[i++] = id;
        }
        this.run(idArgs);
    }

    private void editCodePaths() {
        if (this.codePaths != null) {
            BorderPane borderPane = (BorderPane)Fx.create(BorderPane.class);
            ScrollPane scrollPane = (ScrollPane)Fx.create(ScrollPane.class);
            VBox vBox = (VBox)Fx.create(VBox.class);
            vBox.setPadding(new Insets(10.0));
            vBox.setSpacing(5.0);
            scrollPane.setMinWidth(300.0);
            scrollPane.setMinHeight(150.0);
            for (Map.Entry<String, Boolean> entry : this.codePaths.entrySet()) {
                CheckBox checkBox = (CheckBox)Fx.create(CheckBox.class);
                checkBox.setText(entry.getKey());
                checkBox.setSelected(entry.getValue().booleanValue());
                checkBox.setOnAction(e -> entry.setValue(checkBox.isSelected()));
                vBox.getChildren().add((Object)checkBox);
            }
            scrollPane.setContent((Node)vBox);
            borderPane.setCenter((Node)scrollPane);
            Label headerLabel = (Label)Fx.create(Label.class);
            headerLabel.setText("Code Paths");
            headerLabel.setStyle(POPUP_CSS);
            BorderPane.setAlignment((Node)headerLabel, (Pos)Pos.CENTER);
            borderPane.setTop((Node)headerLabel);
            Popup popup = new Popup();
            Parent notification = FxFactory.getInstance().createNotificationBuilder().content((Node)borderPane).hide(() -> ((Popup)popup).hide()).build();
            FxUtilities.getInstance().showNotification((Object)this.getView(), popup, notification, null);
        }
    }

    private void generateCode() {
        ObservableList selectedItems = this.pdosTableView.getSelectionModel().getSelectedItems();
        if (!selectedItems.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("// generated at ").append(FormatHelper.formatShortTimestamp((Date)new Timestamp())).append(" by ").append(System.getProperty("user.name")).append('@').append(this.mojo.getHostName()).append(" from ").append(this.getDomainContext().getSession()).append('\n');
            DataObject[] dataObjects = new DataObject[selectedItems.size()];
            int i = 0;
            for (PdoWrapper pdoWrapper : selectedItems) {
                dataObjects[i++] = pdoWrapper.getDataObject();
            }
            String text = JavaCodeFactory.generateCode(this.codePaths, dataObjects);
            buf.append(text);
            PdoBrowserUtils.copyToClipboard(buf.toString());
            Note infoNote = (Note)Fx.create(Note.class);
            infoNote.setPosition(Note.Position.TOP);
            String topic = selectedItems.size() > 1 ? selectedItems.size() + " " + this.dataObject.getPdo().getPlural() : this.dataObject.toString();
            infoNote.setText("Java code for " + topic + " copied to clipboard");
            infoNote.setFadeEffect(500L, 2000L, 1000L);
            infoNote.show((Node)this.generateButton);
        }
    }

    private GuiProvider<?> getGuiProvider(PersistentDomainObject proxy) {
        if (GuiProviderFactory.getInstance().isGuiProviderAvailable(proxy.getEffectiveClass())) {
            return GuiProviderFactory.getInstance().createGuiProvider(proxy);
        }
        return null;
    }

    private void close(Event event) {
        this.getStage().hide();
    }

    private DataNode getSelectedDetailDataNode() {
        return (DataNode)this.rowDetailsTable.getSelectionModel().getSelectedItem();
    }
}

