/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.maven.plugin.wizard.OperationGenerator;
import org.tentackle.maven.plugin.wizard.OperationMojo;
import org.tentackle.maven.plugin.wizard.OperationProfile;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationUtilities;

@FxControllerService(resources="NONE")
public class OperationWizard
extends AbstractFxController {
    @Bindable
    private final OperationGenerator gen = new OperationGenerator();
    @FXML
    private FxChoiceBox<OperationProfile> genProfile;
    @FXML
    private FxTextField genOperationName;
    @FXML
    private FxTextField genSuperOperation;
    @FXML
    private FxCheckBox genAbstractOperation;
    @FXML
    private FxTextField genShortDescription;
    @FXML
    private FxTextArea genLongDescription;
    @FXML
    private FxTextField genDomainInterface;
    @FXML
    private FxTextField genPersistenceInterface;
    @FXML
    private FxTextField genDomainImplementation;
    @FXML
    private FxTextField genPersistenceImplementation;
    @FXML
    private FxCheckBox genRemoteEnabled;
    @FXML
    private FxButton cancel;
    @FXML
    private FxButton generate;

    public void applyMojo(OperationMojo mojo) {
        this.genProfile.getItems().clear();
        List<OperationProfile> profiles = mojo.getOperationProfiles();
        this.genProfile.getItems().addAll(profiles);
        if (!profiles.isEmpty()) {
            this.gen.setProfile(profiles.get(0));
        }
        this.gen.setTemplateDirectory(new File(mojo.getTemplateDir(), "operation"));
        this.gen.initializeRemoteDefault();
    }

    public void configure() {
        this.cancel.setGraphic(Fx.createGraphic((String)"cancel"));
        this.generate.setGraphic(Fx.createGraphic((String)"generate"));
        this.genProfile.setDeselectAllowed(Boolean.valueOf(false));
        this.genOperationName.addModelToViewListener(() -> {
            this.genDomainInterface.updateView();
            this.genDomainImplementation.updateView();
            this.genPersistenceInterface.updateView();
            this.genPersistenceImplementation.updateView();
            this.genRemoteEnabled.updateView();
        });
        this.genDomainInterface.addModelToViewListener(() -> ((FxTextField)this.genDomainImplementation).updateView());
        this.genPersistenceInterface.addModelToViewListener(() -> {
            this.genPersistenceImplementation.updateView();
            this.genRemoteEnabled.updateView();
        });
        this.cancel.setOnAction(e -> this.close());
        this.generate.setOnAction(e -> {
            if (this.gen.getDomainInterface() != null && this.gen.getDomainImplementation() == null) {
                Fx.yes((Object)this.getView(), (String)"do you really don't want a domain implementation?", (boolean)false, this::generateIt);
            } else if (this.gen.getPersistenceInterface() != null && this.gen.getPersistenceImplementation() == null) {
                Fx.yes((Object)this.getView(), (String)"do you really don't want a persistence implementation?", (boolean)false, this::generateIt);
            } else {
                this.generateIt();
            }
        });
    }

    private void generateIt() {
        try {
            List<ValidationResult> results = this.gen.generate();
            if (results.isEmpty()) {
                Fx.info((Object)this.getView(), (String)"operation classes generated!", this::close);
            } else {
                Fx.error((Object)this.getView(), (String)ValidationUtilities.getInstance().resultsToMessage(results));
            }
        }
        catch (TemplateException | IOException ex) {
            Fx.error((Object)this.getView(), (String)"code generation failed", (Throwable)ex);
        }
    }

    private void close() {
        Fx.getStage((Node)this.getView()).close();
    }
}

