/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.common.EncryptedProperties;
import org.tentackle.common.InterruptedRuntimeException;
import org.tentackle.maven.plugin.wizard.AbstractWizardMojo;
import org.tentackle.maven.plugin.wizard.fx.PdoBrowser;
import org.tentackle.model.Model;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.sql.datatypes.AbstractDataType;

@Mojo(name="browse", aggregator=true)
public class BrowseMojo
extends AbstractWizardMojo {
    @Parameter(required=true)
    protected String url;
    @Parameter(required=true)
    public String user;
    @Parameter
    public String password;
    @Parameter
    public int maxLinesInStringLiteral;
    @Parameter(property="tentackle.mapSchemas")
    public boolean mapSchemas;
    private Stage stage;

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        super.executeImpl();
        AbstractDataType.maxLinesInLiteral = this.maxLinesInStringLiteral;
        EncryptedProperties props = new EncryptedProperties();
        props.setProperty("url", this.url);
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        SessionInfo sessionInfo = Pdo.createSessionInfo((EncryptedProperties)props);
        try (Session session = Pdo.createSession((SessionInfo)sessionInfo);){
            DomainContext context = Pdo.createDomainContext((Session)session);
            ModificationTracker pdoTracker = ModificationTracker.getInstance();
            pdoTracker.setSession(session);
            CountDownLatch latch = new CountDownLatch(1);
            Platform.startup(() -> {
                try {
                    this.configureFx();
                    this.registerUncaughtExceptionHandler();
                    session.makeCurrent();
                    this.stage = PdoBrowser.show(this, context);
                    this.stage.setOnHidden(event -> latch.countDown());
                }
                catch (Throwable t) {
                    this.getLog().error(t);
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedRuntimeException((Throwable)e);
            }
        }
        catch (PersistenceException ex) {
            throw new MojoExecutionException("no backend found", (Exception)((Object)ex));
        }
    }

    @Override
    protected Stage getStage() {
        return this.stage;
    }

    @Override
    protected void loadModel() throws MojoFailureException, MojoExecutionException {
        if (this.mapSchemas) {
            Model.getInstance().setSchemaNameMapped(true);
        }
        super.loadModel();
    }
}

