/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataList;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.misc.Convertible;
import org.tentackle.misc.Holder;
import org.tentackle.misc.ObjectUtilities;
import org.tentackle.model.Attribute;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;

public class JavaCodeFactory {
    public static final String NOTEST_STEREOTYPE = "NOTEST";
    private static final String HIDDEN_COMMENT = "// hidden: ";
    public static boolean distinctVariables;
    public static Integer variableOffset;
    private final Map<String, Boolean> codePaths;
    private final DataObject[] dataObjects;
    private final Map<String, Holder<Integer>> nameMap;

    public static String generateCode(Map<String, Boolean> codePaths, DataObject ... dataObjects) {
        return new JavaCodeFactory(codePaths, dataObjects).generate();
    }

    private JavaCodeFactory(Map<String, Boolean> codePaths, DataObject ... dataObjects) {
        this.codePaths = codePaths;
        this.dataObjects = dataObjects;
        this.nameMap = new HashMap<String, Holder<Integer>>();
    }

    public String generate() {
        StringBuilder buf = new StringBuilder();
        for (DataObject dataObject : this.dataObjects) {
            if (!buf.isEmpty()) {
                buf.append('\n');
            }
            String varName = this.createVarName(dataObject.getType());
            buf.append(this.createComponentCode(varName, dataObject));
            if (!dataObject.getPdo().isRootEntity()) continue;
            if (distinctVariables) {
                buf.append(varName).append(" = ").append(varName).append(".persist();\n");
                continue;
            }
            buf.append(varName).append(".save();\n");
        }
        return buf.toString();
    }

    private Holder<Integer> getVariableCount(String varName) {
        return this.nameMap.computeIfAbsent(varName, n -> new Holder((Object)(variableOffset == null ? 0 : variableOffset)));
    }

    private String createVarName(String type) {
        Object varName = StringHelper.firstToLower((String)type);
        Holder<Integer> holder = this.getVariableCount((String)varName);
        int count = (Integer)holder.get();
        if (distinctVariables && (count > 0 || variableOffset != null)) {
            varName = (String)varName + count;
        }
        holder.accept((Object)(count + 1));
        return varName;
    }

    private String createNodeCode(String varName, DataNode node) {
        String code;
        if (node instanceof DataItem) {
            DataItem item = (DataItem)node;
            code = this.createItemCode(varName, item);
        } else if (node instanceof DataObject) {
            DataObject component = (DataObject)node;
            StringBuilder buf = new StringBuilder();
            Relation relation = component.getRelation();
            if (relation == null || this.isGenerating(!relation.getStereotypes().contains(NOTEST_STEREOTYPE), node)) {
                String componentName = this.createVarName(component.getType());
                buf.append(this.createComponentCode(componentName, component));
                if (relation != null) {
                    buf.append(varName).append('.').append(relation.getSetterName()).append('(').append(componentName).append(");\n");
                }
            }
            code = buf.toString();
        } else if (node instanceof DataList) {
            DataList list = (DataList)node;
            code = this.createListCode(varName, list);
        } else {
            code = "";
        }
        return code;
    }

    private String createItemCode(String varName, DataItem item) {
        StringBuilder buf = new StringBuilder();
        Attribute attribute = item.getAttribute();
        if (!item.isIdOfCompositeRelation() && attribute != null && !attribute.isImplicit() && this.isGenerating(!attribute.getOptions().getStereotypes().contains(NOTEST_STEREOTYPE), item) && !item.isCounterForListRelation()) {
            if (item.isHidden()) {
                buf.append(HIDDEN_COMMENT);
            }
            Object orgValue = item.getOrgValue();
            NonCompositeRelation nonCompositeRelation = item.getNonCompositeRelation();
            if (nonCompositeRelation != null) {
                Relation relation = nonCompositeRelation.getRelation();
                buf.append(varName).append('.').append(relation.getSetterName()).append("(Objects.requireNonNull(on(").append(relation.getForeignEntity()).append(".class).selectByUniqueDomainKey(").append(this.extractUdkLiteral(nonCompositeRelation.getRelatedPdo())).append(")));").append(this.toIdComment(nonCompositeRelation.getRelatedPdo())).append('\n');
            } else if (this.isSettingNecessary(orgValue, attribute)) {
                if (orgValue != null) {
                    Object str;
                    DataType dataType = attribute.getDataType();
                    if (attribute.isConvertible()) {
                        if (orgValue.getClass().isEnum()) {
                            str = orgValue.getClass().getSimpleName() + "." + ((Enum)orgValue).name();
                        } else {
                            try {
                                dataType = attribute.getInnerDataType();
                                str = orgValue.getClass().getSimpleName() + ".toInternal(" + dataType.valueOfLiteralToCode(((Convertible)orgValue).toExternal().toString(), null) + ")";
                            }
                            catch (ModelException e) {
                                str = dataType.valueOfLiteralToCode(orgValue.toString(), null);
                            }
                        }
                    } else {
                        str = dataType.valueOfLiteralToCode(item.getValue(), null);
                    }
                    buf.append(varName).append('.').append(attribute.getSetterName()).append("(").append((String)str).append(");\n");
                } else {
                    buf.append(varName).append('.').append(attribute.getSetterName()).append("(null);\n");
                }
            }
        }
        return buf.toString();
    }

    private String createComponentCode(String varName, DataObject component) {
        StringBuilder buf = new StringBuilder();
        if (component.isHidden()) {
            buf.append(HIDDEN_COMMENT);
        }
        if (distinctVariables || (Integer)this.getVariableCount(varName).get() == 1) {
            buf.append(component.getType()).append(' ');
        }
        buf.append(varName).append(" = on(").append(component.getType()).append(".class);").append(this.toIdComment(component.getPdo())).append('\n');
        for (DataNode node : component.getNodes()) {
            buf.append(this.createNodeCode(varName, node));
        }
        return buf.toString();
    }

    private String createListCode(String varName, DataList list) {
        StringBuilder buf = new StringBuilder();
        if (list.getRelation() != null && this.isGenerating(!list.getRelation().getStereotypes().contains(NOTEST_STEREOTYPE), list)) {
            for (DataObject object : list.getNodes()) {
                String objectName = this.createVarName(object.getType());
                NonCompositeRelation listRelation = object.getNmRelation();
                if (listRelation != null && this.isGenerating(true, list)) {
                    Relation relation = listRelation.getRelation();
                    Relation nmRelation = relation.getNmRelation();
                    buf.append(varName).append(".get").append(relation.getNmMethodName()).append("().add(Objects.requireNonNull(on(").append(nmRelation.getForeignEntity()).append(".class).selectByUniqueDomainKey(").append(this.extractUdkLiteral(listRelation.getRelatedPdo())).append(")));").append(this.toIdComment(listRelation.getRelatedPdo())).append('\n');
                    continue;
                }
                buf.append(this.createComponentCode(objectName, object));
                if (list.isHidden()) {
                    buf.append(HIDDEN_COMMENT);
                }
                buf.append(varName).append('.').append(list.getRelation().getGetterName()).append("().add(").append(objectName).append(");\n");
            }
        }
        return buf.toString();
    }

    private boolean isSettingNecessary(Object orgValue, Attribute attribute) {
        Object defaultValue;
        String nonNullDefault = attribute.getOptions().getInitialValue();
        if (nonNullDefault == null) {
            nonNullDefault = attribute.getOptions().getNewValue();
        }
        Object object = defaultValue = nonNullDefault == null ? null : attribute.getDataType().valueOf(nonNullDefault);
        if (defaultValue == null && attribute.getDataType().isPrimitive()) {
            if (orgValue instanceof Number) {
                Number number = (Number)orgValue;
                return !ObjectUtilities.getInstance().isZero(number);
            }
            if (orgValue instanceof Boolean) {
                Boolean bool = (Boolean)orgValue;
                return bool;
            }
            if (orgValue instanceof Character) {
                Character c = (Character)orgValue;
                return c.charValue() != '\u0000';
            }
        }
        return !Objects.equals(orgValue, defaultValue);
    }

    private String extractUdkLiteral(PersistentDomainObject<?> pdo) {
        Class uniqueDomainKeyType = pdo.getUniqueDomainKeyType();
        Object object = pdo.getUniqueDomainKey();
        if (object instanceof Convertible) {
            Convertible convertible = (Convertible)object;
            Object external = convertible.toExternal();
            DataType externalType = DataTypeFactory.getInstance().get(external.getClass());
            return uniqueDomainKeyType.getSimpleName() + ".toInternal(" + externalType.valueOfLiteralToCode(external.toString(), null) + ")";
        }
        DataType dataType = DataTypeFactory.getInstance().get(uniqueDomainKeyType);
        if (dataType != null) {
            return dataType.valueOfLiteralToCode(pdo.getUniqueDomainKey().toString(), null);
        }
        return uniqueDomainKeyType.getSimpleName() + ".valueOf(\"" + String.valueOf(pdo.getUniqueDomainKey()) + "\")";
    }

    private String toIdComment(PersistentDomainObject<?> pdo) {
        if (pdo != null && !pdo.isEmbedded()) {
            return "    // [" + pdo.getId() + "/" + pdo.getSerial() + "]";
        }
        return "";
    }

    private boolean isGenerating(boolean generating, DataNode node) {
        Boolean toggle;
        String configurationPath;
        if (this.codePaths != null && (configurationPath = node.getConfigurationPath()) != null && (toggle = this.codePaths.get(configurationPath)) != null) {
            generating = toggle;
        }
        return generating;
    }
}

