/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.log.Logger;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataList;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCondition;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.Persistent;

public class DataNodeFactory {
    private static final Logger LOGGER = Logger.get(DataNodeFactory.class);
    private static final String PO_SUFFIX = "PersistenceObject";
    private static final Map<Class<? extends PersistentDomainObject<?>>, ClassInfo> classMap = new ConcurrentHashMap();

    public static DataObject create(PersistentDomainObject<?> pdo) {
        pdo.loadComponents(false);
        return DataNodeFactory.getDataObject(pdo, null, null, null, false, null);
    }

    private static DataObject getDataObject(PersistentDomainObject<?> pdo, String name, String comment, PersistentDomainObject<?> parentPdo, boolean hidden, Relation compositeRelation) {
        int ndx;
        String relationName;
        Relation relation;
        ClassInfo parentInfo;
        String entityComment;
        ClassInfo classInfo = classMap.computeIfAbsent(pdo.getEffectiveClass(), effectiveClass -> new ClassInfo((Class<? extends PersistentDomainObject<?>>)effectiveClass, pdo.getPersistenceDelegate().getClass()));
        if ((comment == null || comment.equals(classInfo.entity.getName())) && (entityComment = classInfo.entity.getOptions().getComment()) != null) {
            comment = entityComment;
        }
        ArrayList<DataNode> nodes = new ArrayList<DataNode>();
        for (MethodInfo methodInfo : classInfo.methodInfos) {
            try {
                Attribute attribute;
                Object value = methodInfo.getter.invoke((Object)pdo.getPersistenceDelegate(), new Object[0]);
                if (methodInfo.isComponent) {
                    Relation relation2 = classInfo.entity.getRelation(methodInfo.name, true);
                    if (relation2 != null && relation2.isEmbedding()) {
                        StringBuilder prefix = new StringBuilder();
                        if (compositeRelation.isEmbedding()) {
                            prefix.append(compositeRelation.getColumnPrefix());
                        }
                        if (relation2.isEmbedding()) {
                            prefix.append(relation2.getColumnPrefix());
                        }
                        relation2 = relation2.createEmbedded(classInfo.entity, methodInfo.name, prefix.toString());
                    }
                    if (methodInfo.isList) {
                        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
                        List components = (List)value;
                        boolean needSort = false;
                        if (components != null) {
                            for (PersistentDomainObject component : components) {
                                DataObject dataObject = DataNodeFactory.createDataObject(methodInfo.name, methodInfo.comment, component, pdo, false, relation2);
                                dataObjects.add(dataObject);
                                if (dataObject.getNmRelation() == null) continue;
                                needSort = true;
                            }
                        }
                        if (needSort) {
                            dataObjects.sort((o1, o2) -> {
                                if (o1.getNmRelation() != null && o2.getNmRelation() != null) {
                                    return o1.getNmRelation().toString().compareTo(o2.getNmRelation().toString());
                                }
                                return Long.compare(o1.getId(), o2.getId());
                            });
                        }
                        nodes.add(new DataList(methodInfo.typeName, methodInfo.name, methodInfo.comment, dataObjects, relation2, new SqlCondition(pdo.getId(), relation2.getForeignAttribute())));
                        continue;
                    }
                    nodes.add(DataNodeFactory.createDataObject(methodInfo.name, methodInfo.comment, (PersistentDomainObject)value, pdo, methodInfo.isHidden, relation2));
                    continue;
                }
                if ("rootId".equals(methodInfo.name) && !pdo.isRootIdProvided() || "rootClassId".equals(methodInfo.name) && !pdo.isRootClassIdProvided() || "tableSerial".equals(methodInfo.name) && !pdo.isTableSerialProvided() || "normText".equals(methodInfo.name) && !pdo.isNormTextProvided() || "editedBy".equals(methodInfo.name) && !pdo.isTokenLockProvided() || "editedSince".equals(methodInfo.name) && !pdo.isTokenLockProvided() || "editedExpiry".equals(methodInfo.name) && !pdo.isTokenLockProvided() || pdo.isEmbedded() && ("id".equals(methodInfo.name) || "serial".equals(methodInfo.name) || "classId".equals(methodInfo.name))) continue;
                boolean idOfCompositeRelation = false;
                NonCompositeRelation nonCompositeRelation = null;
                if ("long".equals(methodInfo.typeName) || "Long".equals(methodInfo.typeName)) {
                    List allRelations;
                    try {
                        allRelations = classInfo.entity.getAllRelations();
                    }
                    catch (ModelException mx) {
                        throw new TentackleRuntimeException((Throwable)mx);
                    }
                    for (Relation relation3 : allRelations) {
                        Attribute attribute2;
                        if (relation3.getRelationType() != RelationType.OBJECT || (attribute2 = relation3.getAttribute()) == null || !attribute2.getName().equals(methodInfo.name)) continue;
                        Relation foreignRelation = relation3.getForeignRelation();
                        if (relation3.isComposite() || foreignRelation != null && foreignRelation.isComposite()) {
                            idOfCompositeRelation = true;
                            break;
                        }
                        String getterName = relation3.getGetterName();
                        try {
                            PersistentDomainObject relatedPdo;
                            Method getter = classInfo.pdoClass.getMethod(getterName, new Class[0]);
                            Object getterValue = getter.invoke(pdo, new Object[0]);
                            if (!(getterValue instanceof PersistentDomainObject) || !(relatedPdo = (PersistentDomainObject)getterValue).isUniqueDomainKeyProvided()) continue;
                            nonCompositeRelation = new NonCompositeRelation(relation3, relatedPdo);
                            break;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            LOGGER.warning("cannot load 1:1 relation: " + getterName, (Throwable)e);
                        }
                    }
                }
                if ((attribute = classInfo.entity.getAttributeByJavaName(methodInfo.name, true)) == null && "classId".equals(methodInfo.name)) continue;
                Entity entity = classInfo.entity;
                if (compositeRelation != null && compositeRelation.isEmbedding()) {
                    if (attribute != null) {
                        attribute = attribute.createEmbedded(classInfo.entity, compositeRelation.getPathName(), compositeRelation.getColumnPrefix() + attribute.getColumnName());
                    }
                    entity = (Entity)compositeRelation.getEmbeddingPath().getFirst();
                }
                nodes.add(new DataItem(methodInfo.typeName, methodInfo.name, value, methodInfo.comment, entity, attribute, idOfCompositeRelation, nonCompositeRelation, new SqlCondition(pdo.getId(), classInfo.entity.getAttributeByJavaName("id", true))));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warning("cannot determine method return value", (Throwable)e);
            }
        }
        Relation objectRelation = null;
        NonCompositeRelation nmRelation = null;
        if (parentPdo != null && (parentInfo = classMap.get(parentPdo.getEffectiveClass())) != null && (relation = parentInfo.entity.getRelation(relationName = (ndx = name.indexOf(91)) >= 0 ? name.substring(0, ndx) : name, true)) != null && relation.isComposite()) {
            objectRelation = relation;
            Relation nmRel = relation.getNmRelation();
            if (nmRel != null) {
                String getterName = nmRel.getGetterName();
                try {
                    PersistentDomainObject relatedPdo;
                    Method getter = classInfo.pdoClass.getMethod(getterName, new Class[0]);
                    Object getterValue = getter.invoke(pdo, new Object[0]);
                    if (getterValue instanceof PersistentDomainObject && (relatedPdo = (PersistentDomainObject)getterValue).isUniqueDomainKeyProvided()) {
                        nmRelation = new NonCompositeRelation(relation, relatedPdo);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.warning("cannot load N:M relation: " + getterName, (Throwable)e);
                }
            }
        }
        return new DataObject(pdo, name, comment, nodes, classInfo.entity, objectRelation, nmRelation, hidden, new SqlCondition(pdo.getId(), classInfo.entity.getAttributeByJavaName("id", true)));
    }

    private static DataObject createDataObject(String name, String comment, PersistentDomainObject<?> pdo, PersistentDomainObject<?> parentPdo, boolean hidden, Relation compositeRelation) {
        DataObject dataObject = pdo == null ? new DataObject(null, name, null, null, null, null, null, hidden, null) : DataNodeFactory.getDataObject(pdo, name, comment, parentPdo, hidden, compositeRelation);
        return dataObject;
    }

    private static String toTypeName(Class<?> type) {
        String typeName = type.getSimpleName();
        if (PersistentDomainObject.class.isAssignableFrom(type) && typeName.endsWith(PO_SUFFIX)) {
            typeName = typeName.substring(0, typeName.length() - PO_SUFFIX.length());
        }
        return typeName;
    }

    private static Entity lookupEntity(String typeName) {
        try {
            Entity entity = Model.getInstance().getByEntityName(typeName);
            if (entity == null) {
                throw new ModelException("entity " + typeName + " missing in model");
            }
            return entity;
        }
        catch (ModelException e) {
            throw new TentackleRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static class ClassInfo {
        private final Class<? extends PersistentDomainObject<?>> pdoClass;
        private final String typeName;
        private final Entity entity;
        private final Set<MethodInfo> methodInfos;

        private ClassInfo(Class<? extends PersistentDomainObject<?>> pdoClass, Class<?> poClass) {
            this.pdoClass = pdoClass;
            this.typeName = DataNodeFactory.toTypeName(pdoClass);
            this.entity = DataNodeFactory.lookupEntity(this.typeName);
            this.methodInfos = new TreeSet<MethodInfo>();
            Method[] pdoClassMethods = pdoClass.getMethods();
            Method[] poClassMethods = ReflectionHelper.getAllMethods(poClass, (Class[])new Class[]{PersistentObject.class}, (boolean)false, null, (boolean)false);
            Method[] methods = new Method[pdoClassMethods.length + poClassMethods.length];
            System.arraycopy(pdoClassMethods, 0, methods, 0, pdoClassMethods.length);
            System.arraycopy(poClassMethods, 0, methods, pdoClassMethods.length, poClassMethods.length);
            for (Method method : methods) {
                Class clz;
                Type typeArg;
                Type[] typeArguments;
                Type genType;
                Persistent annotation;
                boolean isGetter;
                if (method.getParameterCount() != 0 || method.isBridge()) continue;
                String name = method.getName();
                Class type = method.getReturnType();
                boolean bl = isGetter = name.startsWith("get") && Character.isUpperCase(name.charAt(3));
                if (isGetter) {
                    name = StringHelper.firstToLower((String)name.substring(3));
                } else if (name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && (type == Boolean.class || type == Boolean.TYPE)) {
                    name = StringHelper.firstToLower((String)name.substring(2));
                    isGetter = true;
                }
                if (!isGetter || (annotation = method.getAnnotation(Persistent.class)) == null || !annotation.component()) continue;
                boolean isHidden = false;
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                    isHidden = true;
                }
                boolean isComponent = false;
                boolean isList = false;
                if (PersistentDomainObject.class.isAssignableFrom(type)) {
                    isComponent = true;
                } else if (List.class.isAssignableFrom(type) && (genType = method.getGenericReturnType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genType).getActualTypeArguments()) != null && typeArguments.length == 1 && (typeArg = typeArguments[0]) instanceof Class && PersistentDomainObject.class.isAssignableFrom(clz = (Class)typeArg)) {
                    type = clz;
                    isComponent = true;
                    isList = true;
                }
                this.methodInfos.add(new MethodInfo(name, annotation.comment(), method, type, isComponent, isList, isHidden));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassInfo classInfo = (ClassInfo)o;
            return this.pdoClass.equals(classInfo.pdoClass);
        }

        public int hashCode() {
            return this.pdoClass.hashCode();
        }
    }

    private static class MethodInfo
    implements Comparable<MethodInfo> {
        private final String name;
        private final String comment;
        private final Method getter;
        private final String typeName;
        private final boolean isComponent;
        private final boolean isList;
        private final boolean isHidden;

        private MethodInfo(String name, String comment, Method getter, Class<?> type, boolean isComponent, boolean isList, boolean isHidden) {
            this.name = name;
            this.comment = comment;
            this.getter = getter;
            this.isComponent = isComponent;
            this.isList = isList;
            this.typeName = DataNodeFactory.toTypeName(type);
            this.isHidden = isHidden;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(MethodInfo o) {
            int rv = Boolean.compare(this.isComponent, o.isComponent);
            if (rv == 0) {
                rv = this.name.compareTo(o.name);
            }
            return rv;
        }
    }
}

