/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.pdo.PersistentDomainObject;

@TableCellTypeService(value=DataNode.class)
public class DataNodeCellType
extends AbstractTableCellType<DataNode> {
    private static final String STYLE_IMPLICIT = "implicit-attribute";
    private static final String STYLE_HIDDEN = "hidden-component";
    private static final String STYLE_KEY = "key-attribute";

    public void updateItem(FxTableCell<?, DataNode> tableCell, DataNode item) {
        tableCell.setText(this.getName(item));
        tableCell.setGraphic(this.getIcon(item));
        this.updateAlignment(tableCell, Pos.BASELINE_LEFT);
    }

    public void updateItem(FxTreeTableCell<?, DataNode> treeTableCell, DataNode item) {
        DataItem dataItem;
        treeTableCell.setText(this.getName(item));
        treeTableCell.setGraphic(this.getIcon(item));
        treeTableCell.setTooltip(item.getComment() == null ? null : new Tooltip(item.getComment()));
        this.updateAlignment(treeTableCell, Pos.BASELINE_LEFT);
        treeTableCell.getStyleClass().removeAll((Object[])new String[]{STYLE_IMPLICIT, STYLE_HIDDEN, STYLE_KEY});
        if (item instanceof DataItem && ((dataItem = (DataItem)item).getAttribute() == null || dataItem.getAttribute().isImplicit())) {
            treeTableCell.getStyleClass().add((Object)STYLE_IMPLICIT);
        } else if (item.isHidden()) {
            treeTableCell.getStyleClass().add((Object)STYLE_HIDDEN);
        }
        if (item instanceof DataItem && (dataItem = (DataItem)item).isKey()) {
            treeTableCell.getStyleClass().add((Object)STYLE_KEY);
        }
    }

    private String getName(DataNode item) {
        String name = item.getName();
        if (StringHelper.isAllWhitespace((String)name)) {
            name = StringHelper.firstToLower((String)item.getType());
        }
        return name;
    }

    private Node getIcon(DataNode item) {
        if (item instanceof DataObject) {
            GuiProvider guiProvider;
            PersistentDomainObject<?> pdo = ((DataObject)item).getPdo();
            if (GuiProviderFactory.getInstance().isGuiProviderAvailable(pdo.getEffectiveClass()) && (guiProvider = GuiProviderFactory.getInstance().createGuiProvider(pdo)) != null) {
                return guiProvider.createGraphic();
            }
        }
        return Fx.createGraphic((String)"data", (String)item.getClass().getSimpleName());
    }
}

