/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.ArrayList;
import java.util.TreeSet;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCondition;
import org.tentackle.misc.Convertible;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.ModelException;
import org.tentackle.session.ModificationTracker;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendFactory;
import org.tentackle.sql.DataType;
import org.tentackle.sql.JoinType;

public class SqlCodeFactory {
    public static String createSelect(DataNode dataNode) {
        try {
            Backend backend = BackendFactory.getInstance().getBackendByUrl(ModificationTracker.getInstance().getSession().getSessionInfo().getProperties().getProperty("url"));
            DataItem dataItem = null;
            boolean selectAllForItem = false;
            if (dataNode instanceof DataItem) {
                DataItem item;
                dataItem = item = (DataItem)dataNode;
                selectAllForItem = true;
            }
            SqlCondition condition = dataNode.getSqlCondition();
            Entity entity = dataNode.getEntity();
            InheritanceType inheritanceType = entity.getHierarchyInheritanceType();
            String tableName = condition.getTableName() == null ? entity.getTableName() : condition.getTableName();
            String tableAlias = condition.getTableAlias() == null ? entity.getTableAlias() : condition.getTableAlias();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            if (selectAllForItem) {
                entity = dataItem.getAttribute().getEntity();
            }
            if (inheritanceType == InheritanceType.SINGLE) {
                if (entity.getSuperEntity() == null) {
                    sql.append(tableAlias).append(".*");
                } else {
                    boolean needComma = false;
                    for (Attribute attribute : entity.getAllAttributes()) {
                        if (needComma) {
                            sql.append(',');
                        } else {
                            needComma = true;
                        }
                        sql.append(SqlCodeFactory.getSelectedColumn(attribute, tableAlias));
                    }
                }
            } else {
                sql.append(tableAlias).append(".*");
                if (inheritanceType == InheritanceType.MULTI) {
                    ArrayList entities = new ArrayList();
                    entities.addAll(condition.attribute().getEntity().getInheritanceChain(entity).stream().skip(1L).toList());
                    entities.addAll(entity.getSubEntities());
                    entities.forEach(e -> sql.append(',').append(e.getTableAlias()).append(".*"));
                }
            }
            sql.append(" FROM ").append(tableName).append(backend.sqlAsBeforeTableAlias()).append(tableAlias);
            if (inheritanceType == InheritanceType.MULTI) {
                condition.attribute().getEntity().getInheritanceChain(entity).stream().skip(1L).forEach(subEntity -> sql.append(", ").append(subEntity.getTableName()).append(backend.sqlAsBeforeTableAlias()).append(subEntity.getTableAlias()));
                entity.getSubEntities().forEach(subEntity -> sql.append(' ').append(JoinType.LEFT).append(' ').append(subEntity.getTableName()).append(backend.sqlAsBeforeTableAlias()).append(subEntity.getTableAlias()).append(" ON ").append(subEntity.getTableAlias()).append('.').append("id").append('=').append(tableAlias).append('.').append("id"));
            }
            sql.append(" WHERE ");
            if (selectAllForItem) {
                if (inheritanceType == InheritanceType.MULTI) {
                    sql.append(dataItem.getAttribute().getEntity().getTableAlias());
                } else {
                    sql.append(tableAlias);
                }
                sql.append('.').append(dataItem.getAttribute().getColumnName());
                Object orgValue = dataItem.getOrgValue();
                if (orgValue == null && dataItem.getAttribute().getOptions().isMapNull()) {
                    orgValue = dataItem.getAttribute().getDataType().getMappedNullValue(backend, 0);
                }
                if (orgValue == null) {
                    sql.append(" IS NULL");
                } else {
                    String string;
                    if (orgValue instanceof Convertible) {
                        Convertible convertible = (Convertible)orgValue;
                        string = convertible.toExternal().toString();
                    } else {
                        string = orgValue.toString();
                    }
                    String value = string;
                    sql.append('=').append(dataItem.getAttribute().getEffectiveDataType().toLiteral(value, null));
                }
            } else {
                sql.append(tableAlias).append('.').append(condition.attribute().getColumnName()).append('=').append(condition.id());
            }
            if (entity.getSuperEntity() != null) {
                if (inheritanceType == InheritanceType.MULTI) {
                    condition.attribute().getEntity().getInheritanceChain(entity).stream().skip(1L).forEach(subEntity -> sql.append(" AND ").append(subEntity.getTableAlias()).append('.').append("id").append('=').append(tableAlias).append('.').append("id"));
                } else if (inheritanceType == InheritanceType.SINGLE) {
                    TreeSet<Integer> classIds = new TreeSet<Integer>();
                    if (selectAllForItem && entity.getClassId() != 0) {
                        classIds.add(entity.getClassId());
                    }
                    for (Entity subEntity2 : entity.getSubEntities()) {
                        if (entity.getClassId() == 0) continue;
                        classIds.add(subEntity2.getClassId());
                    }
                    if (classIds.size() == 1) {
                        sql.append(" AND ").append(tableAlias).append('.').append("classid").append('=').append(entity.getClassId());
                    } else if (classIds.size() > 1) {
                        sql.append(" AND ").append(tableAlias).append('.').append("classid").append(" IN(");
                        boolean needComma = false;
                        for (Integer classId : classIds) {
                            if (needComma) {
                                sql.append(',');
                            } else {
                                needComma = true;
                            }
                            sql.append(classId);
                        }
                        sql.append(')');
                    }
                }
            }
            sql.append(';');
            return sql.toString();
        }
        catch (RuntimeException | ModelException ex) {
            return "-- " + ex.getMessage();
        }
    }

    private static String getSelectedColumn(Attribute attribute, String tableAlias) throws ModelException {
        DataType dataType = attribute.getEffectiveDataType();
        StringBuilder sql = new StringBuilder();
        int columnCount = dataType.getColumnCount(null);
        for (int col = 0; col < columnCount; ++col) {
            if (col > 0) {
                sql.append(',');
            }
            sql.append(tableAlias).append('.').append(attribute.getColumnName(null, col));
        }
        return sql.toString();
    }
}

