/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.List;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCondition;
import org.tentackle.model.AccessScope;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;

public class DataList
implements DataNode {
    private final String genericType;
    private final String name;
    private final String comment;
    private final List<DataObject> nodes;
    private final Relation relation;
    private final SqlCondition sqlCondition;
    private String configurationPath;

    public DataList(String genericType, String name, String comment, List<DataObject> nodes, Relation relation, SqlCondition sqlCondition) {
        this.genericType = genericType;
        this.name = name;
        this.comment = comment;
        this.nodes = nodes;
        this.relation = relation;
        this.sqlCondition = sqlCondition;
        int ndx = 0;
        for (DataObject node : nodes) {
            node.setDataList(this, ndx++);
        }
    }

    public String getGenericType() {
        return this.genericType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isHidden() {
        return this.relation.getAccessScope() != AccessScope.PUBLIC;
    }

    public List<DataObject> getNodes() {
        return this.nodes;
    }

    @Override
    public SqlCondition getSqlCondition() {
        return this.sqlCondition;
    }

    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public Entity getEntity() {
        return this.relation.getForeignEntity();
    }

    @Override
    public String getType() {
        return "List<" + this.genericType + ">";
    }

    @Override
    public String getValue() {
        return this.nodes == null ? null : Integer.toString(this.nodes.size());
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Override
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getType()).append(' ').append(this.name).append(" = ");
        if (this.nodes == null) {
            buf.append("<null>");
        } else {
            buf.append('[').append(this.nodes.size()).append(']');
        }
        return buf.toString();
    }
}

