/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxComboBox;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.maven.plugin.wizard.PdoProfile;
import org.tentackle.maven.plugin.wizard.fx.PdoType;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=PdoType.class, viewClass=String.class)
public class PdoTypeStringTranslator
extends ValueStringTranslator<PdoType> {
    public static final String ROOT_ONLY = "rootOnly";
    public static final String PROFILE = "profile";
    private Map<String, PdoType> pdoTypeMap;

    public PdoTypeStringTranslator(FxTextComponent component) {
        super(component);
        if (component instanceof FxComboBox) {
            FxComboBox comboBox = (FxComboBox)component;
            this.configureComboBox((FxComboBox<PdoType>)comboBox);
            final Font font = Font.getDefault();
            final Font boldFont = Font.font((String)font.getFamily(), (FontWeight)FontWeight.BOLD, (double)font.getSize());
            Callback<ListView<PdoType>, ListCell<PdoType>> cellFactory = new Callback<ListView<PdoType>, ListCell<PdoType>>(){

                public ListCell<PdoType> call(ListView<PdoType> l) {
                    return new ListCell<PdoType>(){

                        protected void updateItem(PdoType item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (item == null || empty) {
                                this.setGraphic(null);
                            } else {
                                TextFlow textFlow = new TextFlow();
                                String name = item.getName();
                                StringBuilder buf = new StringBuilder();
                                for (int i = 0; i < name.length(); ++i) {
                                    char c = name.charAt(i);
                                    if (Character.isUpperCase(c)) {
                                        if (!buf.isEmpty()) {
                                            PdoTypeStringTranslator.this.addText(textFlow, buf.toString(), font);
                                            buf.setLength(0);
                                        }
                                        PdoTypeStringTranslator.this.addText(textFlow, String.valueOf(c), boldFont);
                                        continue;
                                    }
                                    buf.append(c);
                                }
                                if (!buf.isEmpty()) {
                                    PdoTypeStringTranslator.this.addText(textFlow, buf.toString(), font);
                                }
                                Group group = new Group(new Node[]{textFlow});
                                this.setGraphic((Node)group);
                            }
                        }
                    };
                }
            };
            comboBox.setCellFactory((Callback)cellFactory);
            comboBox.setButtonCell((ListCell)cellFactory.call(null));
        }
    }

    public Function<PdoType, String> toViewFunction() {
        return v -> v == null ? null : v.getName();
    }

    public Function<String, PdoType> toModelFunction() {
        return s -> s == null ? null : this.getPdoTypeMap().get(s);
    }

    public void bindingPropertiesUpdated() {
        FxTextComponent fxTextComponent = this.getComponent();
        if (fxTextComponent instanceof FxComboBox) {
            FxComboBox comboBox = (FxComboBox)fxTextComponent;
            this.pdoTypeMap = null;
            this.configureComboBox((FxComboBox<PdoType>)comboBox);
        }
    }

    private void configureComboBox(FxComboBox<PdoType> comboBox) {
        comboBox.getSelectionModel().clearSelection();
        ArrayList<PdoType> pdoTypes = new ArrayList<PdoType>(this.getPdoTypeMap().values());
        pdoTypes.sort(Comparator.comparing(PdoType::getCamelCaseLetters));
        comboBox.getItems().setAll(pdoTypes);
    }

    private Map<String, PdoType> getPdoTypeMap() {
        if (this.pdoTypeMap == null) {
            boolean rootOnly = Boolean.TRUE.equals(((Node)this.getComponent()).getProperties().get((Object)ROOT_ONLY));
            PdoProfile profile = (PdoProfile)((Node)this.getComponent()).getProperties().get((Object)PROFILE);
            HashMap<String, PdoType> pdoTypeMap = new HashMap<String, PdoType>();
            for (String pdoName : PdoFactory.getInstance().getPersistenceMapper().getMap().keySet()) {
                PersistentDomainObject pdo = PdoFactory.getInstance().create(pdoName);
                Class effectiveClass = pdo.getEffectiveClass();
                if (rootOnly && !pdo.isRootEntity() || pdo.getPersistenceDelegate().isEmbedded() || profile != null && !profile.getPdoPackage().equals(effectiveClass.getPackageName())) continue;
                PdoType pdoType = new PdoType(effectiveClass.getSimpleName(), effectiveClass);
                pdoTypeMap.put(pdoType.getName(), pdoType);
            }
            this.pdoTypeMap = pdoTypeMap;
        }
        return this.pdoTypeMap;
    }

    private void addText(TextFlow textFlow, String str, Font font) {
        Text text = new Text(str);
        text.setFont(font);
        textFlow.getChildren().add((Object)text);
    }
}

