/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.maven.PackageInfo;

public class Profile {
    @Parameter(required=true)
    private String name;
    @Parameter
    private String domainInterface;
    @Parameter
    private String persistenceInterface;
    @Parameter
    private String domainImplementation;
    @Parameter
    private String persistenceImplementation;
    @Parameter(required=true)
    private String domainPackage;
    private PackageInfo domainPackageInfo;
    @Parameter(required=true)
    private String persistencePackage;
    private PackageInfo persistencePackageInfo;
    @Parameter(required=true)
    private String domainImplPackage;
    private PackageInfo domainImplPackageInfo;
    @Parameter(required=true)
    private String persistenceImplPackage;
    private PackageInfo persistenceImplPackageInfo;

    public String getName() {
        return this.name;
    }

    public String getDomainInterface() {
        return this.domainInterface;
    }

    public String getPersistenceInterface() {
        return this.persistenceInterface;
    }

    public String getDomainImplementation() {
        return this.domainImplementation;
    }

    public String getPersistenceImplementation() {
        return this.persistenceImplementation;
    }

    public String getDomainPackage() {
        return this.domainPackage;
    }

    public String getPersistencePackage() {
        return this.persistencePackage;
    }

    public String getDomainImplPackage() {
        return this.domainImplPackage;
    }

    public String getPersistenceImplPackage() {
        return this.persistenceImplPackage;
    }

    public PackageInfo getDomainPackageInfo() {
        return this.domainPackageInfo;
    }

    public PackageInfo getPersistencePackageInfo() {
        return this.persistencePackageInfo;
    }

    public PackageInfo getDomainImplPackageInfo() {
        return this.domainImplPackageInfo;
    }

    public PackageInfo getPersistenceImplPackageInfo() {
        return this.persistenceImplPackageInfo;
    }

    public void validate(Map<String, PackageInfo> packageInfoMap) throws MojoExecutionException {
        this.domainPackageInfo = this.getPackageInfo(packageInfoMap, this.domainPackage);
        this.persistencePackageInfo = this.getPackageInfo(packageInfoMap, this.persistencePackage);
        this.domainImplPackageInfo = this.getPackageInfo(packageInfoMap, this.domainImplPackage);
        this.persistenceImplPackageInfo = this.getPackageInfo(packageInfoMap, this.persistenceImplPackage);
    }

    protected PackageInfo getPackageInfo(Map<String, PackageInfo> packageInfoMap, String packageName) throws MojoExecutionException {
        PackageInfo info = packageInfoMap.get(packageName);
        if (info == null) {
            throw new MojoExecutionException("cannot determine module for package " + packageName);
        }
        if (info.getEmptyDuplicates() != null) {
            StringBuilder buf = new StringBuilder();
            for (PackageInfo other : info.getEmptyDuplicates()) {
                buf.append("\nempty split package detected: ").append(info.getName()).append(" in ").append(info.getProject().getName()).append(" and ").append(other.getProject().getName());
            }
            buf.deleteCharAt(0);
            throw new MojoExecutionException(buf.toString());
        }
        return info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return Objects.equals(this.name, profile.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

