/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.tentackle.common.InterruptedRuntimeException;
import org.tentackle.fx.Fx;
import org.tentackle.maven.plugin.wizard.AbstractWizardMojo;
import org.tentackle.maven.plugin.wizard.PdoProfile;
import org.tentackle.maven.plugin.wizard.fx.PdoWizard;
import org.tentackle.model.Entity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;

@Mojo(name="pdo", inheritByDefault=false, aggregator=true)
public class PdoMojo
extends AbstractWizardMojo {
    private List<PdoProfile> pdoProfiles;

    public List<PdoProfile> getPdoProfiles() {
        return this.pdoProfiles;
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        super.executeImpl();
        this.updateClassIDs();
        CountDownLatch latch = new CountDownLatch(1);
        Platform.startup(() -> {
            try {
                PdoWizard wizard = (PdoWizard)Fx.load(PdoWizard.class);
                wizard.applyMojo(this);
                Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
                Scene scene = Fx.createScene((Parent)wizard.getView());
                stage.setScene(scene);
                stage.setTitle("PDO Wizard");
                wizard.getContainer().updateView();
                stage.setOnHidden(event -> latch.countDown());
                stage.show();
            }
            catch (Throwable t) {
                this.getLog().error(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException((Throwable)e);
        }
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            this.pdoProfiles = this.getProfiles(PdoProfile.class);
            if (this.pdoProfiles.isEmpty()) {
                throw new MojoExecutionException("at least one PdoProfile must be configured");
            }
            Map packageInfoMap = this.createPackageMap(false);
            for (PdoProfile profile : this.pdoProfiles) {
                profile.validate(packageInfoMap);
            }
            return true;
        }
        return false;
    }

    private void updateClassIDs() throws MojoExecutionException {
        TreeSet<PdoProfile> sortedProfiles = new TreeSet<PdoProfile>((o1, o2) -> o2.getMinClassId() - o1.getMinClassId());
        HashMap<PdoProfile, Integer> inUseIds = new HashMap<PdoProfile, Integer>();
        for (PdoProfile profile : this.pdoProfiles) {
            sortedProfiles.add(profile);
            inUseIds.put(profile, profile.getMinClassId());
        }
        int maxClassId = 0;
        int diff = 0;
        for (PdoProfile pdoProfile : sortedProfiles) {
            if (maxClassId > 0) {
                diff = maxClassId - pdoProfile.getMinClassId();
            }
            if (pdoProfile.getMaxClassId() == 0) {
                pdoProfile.setMaxClassId(maxClassId);
            } else if (pdoProfile.getMaxClassId() > maxClassId) {
                throw new MojoExecutionException("class-IDs of profiles must not overlap: " + pdoProfile + " maxClassId <= " + maxClassId);
            }
            maxClassId = pdoProfile.getMinClassId() - 1;
        }
        PdoProfile lastProfile = (PdoProfile)sortedProfiles.first();
        if (lastProfile.getMaxClassId() == 0) {
            lastProfile.setMaxClassId(lastProfile.getMinClassId() + diff);
        }
        try {
            block4: for (Entity entity : Model.getInstance().getAllEntitites()) {
                int classId = entity.getClassId();
                if (classId <= 0) continue;
                for (PdoProfile profile : sortedProfiles) {
                    if (classId < profile.getMinClassId() || classId > profile.getMaxClassId()) continue;
                    if ((Integer)inUseIds.get(profile) >= classId) continue block4;
                    inUseIds.put(profile, classId);
                    continue block4;
                }
            }
        }
        catch (ModelException modelException) {
            throw new MojoExecutionException("cannot determine class IDs", (Exception)((Object)modelException));
        }
        for (Map.Entry entry : inUseIds.entrySet()) {
            PdoProfile profile = (PdoProfile)entry.getKey();
            int classId = (Integer)entry.getValue() + 1;
            Integer statusClassId = this.loadClassIdFromStatus(profile.getName());
            if (statusClassId != null && statusClassId > classId) {
                classId = statusClassId;
            }
            profile.setMinClassId(classId);
            if (classId > profile.getMaxClassId()) {
                this.getLog().warn((CharSequence)("no more free class-IDs for " + profile));
                continue;
            }
            this.getLog().info((CharSequence)("next free class-ID for " + profile + " is " + profile.getMinClassId() + ", max. " + profile.getMaxClassId()));
        }
    }

    private Integer loadClassIdFromStatus(String profileName) {
        Integer classId = null;
        try (BufferedReader statusReader = new BufferedReader(new FileReader(new File(this.getStatusDir(), profileName + ".classid")));){
            classId = Integer.parseInt(statusReader.readLine());
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        return classId;
    }
}

