/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.Map;
import org.tentackle.bind.Bindable;
import org.tentackle.maven.plugin.wizard.pdodata.CodeConfigurationFactory;
import org.tentackle.maven.plugin.wizard.pdodata.DataNodeFactory;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.misc.ShortLongText;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoWrapper {
    private final PersistentDomainObject<?> pdo;
    private String udk;
    private DataObject dataObject;
    private Map<String, Boolean> codeConfiguration;

    public PdoWrapper(PersistentDomainObject<?> pdo) {
        this.pdo = pdo;
    }

    public PersistentDomainObject<?> getPdo() {
        return this.pdo;
    }

    public DataObject getDataObject() {
        if (this.dataObject == null) {
            this.dataObject = DataNodeFactory.create(this.pdo);
        }
        return this.dataObject;
    }

    public Map<String, Boolean> getCodeConfiguration() {
        if (this.codeConfiguration == null) {
            this.codeConfiguration = CodeConfigurationFactory.createConfig(this.getDataObject());
        }
        return this.codeConfiguration;
    }

    @Bindable
    public long getId() {
        return this.pdo.getId();
    }

    @Bindable
    public String getUDK() {
        if (this.udk == null) {
            Object udkStr = "";
            PersistentDomainObject<?> persistentDomainObject = this.pdo;
            if (persistentDomainObject instanceof ShortLongText) {
                ShortLongText shortLongText = (ShortLongText)persistentDomainObject;
                udkStr = shortLongText.getShortText() + " (" + shortLongText.getLongText() + ")";
            } else if (this.pdo.isUniqueDomainKeyProvided()) {
                Object uniqueDomainKey = this.pdo.getUniqueDomainKey();
                if (uniqueDomainKey != null) {
                    udkStr = uniqueDomainKey.toString();
                }
            } else {
                udkStr = this.pdo.toString();
            }
            this.udk = udkStr;
        }
        return this.udk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdoWrapper that = (PdoWrapper)o;
        return this.pdo.equals(that.pdo);
    }

    public int hashCode() {
        return this.pdo.hashCode();
    }
}

