/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tentackle.bind.Bindable;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCondition;
import org.tentackle.model.Entity;

public class DataDiff
implements DataNode {
    private final DataNode left;
    private final DataNode right;
    private final boolean different;
    private final List<DataDiff> nodes;

    public DataDiff(DataNode left, DataNode right, boolean different, List<DataDiff> nodes) {
        this.left = left;
        this.right = right;
        this.different = different;
        this.nodes = nodes;
    }

    public DataNode getLeft() {
        return this.left;
    }

    public DataNode getRight() {
        return this.right;
    }

    public boolean isDifferent() {
        return this.different;
    }

    public List<DataDiff> getNodes() {
        return this.nodes;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    @Bindable(ordinal=2)
    public String getType() {
        if (this.left != null) {
            return this.left.getType();
        }
        return this.right.getType();
    }

    @Override
    public String getName() {
        if (this.left != null) {
            return this.left.getName();
        }
        return this.right.getName();
    }

    @Override
    public String getValue() {
        if (this.left != null) {
            return this.left.getValue();
        }
        return this.right.getValue();
    }

    public String toString() {
        if (this.left != null) {
            return this.left.toString();
        }
        return this.right.toString();
    }

    @Override
    public String getNodeType() {
        if (this.left != null) {
            return this.left.getNodeType();
        }
        return this.right.getNodeType();
    }

    @Bindable(ordinal=1)
    public DataNode getNode() {
        if (this.left != null) {
            return this.left;
        }
        return this.right;
    }

    @Bindable(ordinal=3)
    public String getLeftValue() {
        return this.left == null ? null : this.left.getValue();
    }

    @Bindable(ordinal=4)
    public String getRightValue() {
        return this.right == null ? null : this.right.getValue();
    }

    public boolean isLeftPresent() {
        return this.left != null;
    }

    public boolean isRightPresent() {
        return this.right != null;
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        throw new UnsupportedOperationException("no applicable to diffs");
    }

    @Override
    public String getConfigurationPath() {
        return null;
    }

    @Override
    public SqlCondition getSqlCondition() {
        return this.left != null ? this.left.getSqlCondition() : this.right.getSqlCondition();
    }

    @Override
    public Entity getEntity() {
        return this.left != null ? this.left.getEntity() : this.right.getEntity();
    }

    public static DataDiff compare(DataObject left, DataObject right) {
        boolean rootIdDiffers = left != null && right != null && left.getId() != right.getId();
        return DataDiff.compareImpl(Objects.requireNonNull(left), right, right == null, rootIdDiffers);
    }

    private static DataDiff compareImpl(DataNode left, DataNode right, boolean rightMissing, boolean rootIdDiffers) {
        boolean different;
        ArrayList<DataDiff> diffNodes;
        if (left != null && right != null && left.getClass() != right.getClass()) {
            throw new IllegalArgumentException("cannot compare " + left.getClass() + " with " + right.getClass());
        }
        if (left == null && right == null) {
            diffNodes = null;
            different = false;
        } else if (left instanceof DataItem || right instanceof DataItem) {
            diffNodes = null;
            if (left != null && right != null) {
                DataItem leftItem = (DataItem)left;
                DataItem rightItem = (DataItem)right;
                different = leftItem.isIdOfCompositeRelation() && rightItem.isIdOfCompositeRelation() || leftItem.getAttribute() != null && leftItem.getAttribute().isImplicit() && rightItem.getAttribute() != null && rightItem.getAttribute().isImplicit() ? false : !Objects.equals(left.getValue(), right.getValue());
            } else {
                different = false;
            }
        } else {
            int rightSize;
            diffNodes = new ArrayList<DataDiff>();
            List<? extends DataNode> leftNodes = left == null ? null : left.getNodes();
            List<? extends DataNode> rightNodes = right == null ? null : right.getNodes();
            int leftSize = leftNodes == null ? 0 : leftNodes.size();
            int n = rightSize = rightNodes == null ? 0 : rightNodes.size();
            if (left instanceof DataObject || right instanceof DataObject) {
                long rightSerial;
                long rightId;
                NonCompositeRelation nmRelation;
                long leftSerial;
                long leftId;
                DataObject leftObject = (DataObject)left;
                DataObject rightObject = (DataObject)right;
                if (leftObject == null) {
                    leftId = 0L;
                    leftSerial = 0L;
                } else {
                    nmRelation = leftObject.getNmRelation();
                    if (nmRelation != null) {
                        leftId = nmRelation.getRelatedPdo().getId();
                        leftSerial = nmRelation.getRelatedPdo().getSerial();
                    } else {
                        leftId = leftObject.getId();
                        leftSerial = leftObject.getSerial();
                    }
                }
                if (rightObject == null) {
                    rightId = 0L;
                    rightSerial = 0L;
                } else {
                    nmRelation = rightObject.getNmRelation();
                    if (nmRelation != null) {
                        rightId = nmRelation.getRelatedPdo().getId();
                        rightSerial = nmRelation.getRelatedPdo().getSerial();
                    } else {
                        rightId = rightObject.getId();
                        rightSerial = rightObject.getSerial();
                    }
                }
                different = !rightMissing && (leftSerial != rightSerial || leftId != rightId);
                int size = Math.max(leftSize, rightSize);
                for (int i = 0; i < size; ++i) {
                    DataNode leftNode = i < leftSize ? leftNodes.get(i) : null;
                    DataNode rightNode = i < rightSize ? rightNodes.get(i) : null;
                    DataDiff diffNode = DataDiff.compareImpl(leftNode, rightNode, rightMissing, rootIdDiffers);
                    diffNodes.add(diffNode);
                    different |= !rightMissing && diffNode.different;
                }
            } else {
                different = false;
                List<? extends DataNode> leftObjects = leftNodes;
                List<? extends DataNode> rightObjects = rightNodes;
                int leftIndex = 0;
                int rightIndex = 0;
                DataObject nextLeft = null;
                DataObject nextRight = null;
                while (true) {
                    DataDiff diffNode;
                    if (nextLeft == null && leftIndex < leftSize) {
                        nextLeft = (DataObject)leftObjects.get(leftIndex++);
                    }
                    if (nextRight == null && rightIndex < rightSize) {
                        nextRight = (DataObject)rightObjects.get(rightIndex++);
                    }
                    if (nextLeft == null && nextRight == null) break;
                    if (nextLeft == null) {
                        diffNode = DataDiff.compareImpl(null, nextRight, rightMissing, rootIdDiffers);
                        nextRight = null;
                    } else if (nextRight == null) {
                        diffNode = DataDiff.compareImpl(nextLeft, null, rightMissing, rootIdDiffers);
                        nextLeft = null;
                    } else if (nextLeft.getNmRelation() != null && nextRight.getNmRelation() != null && nextLeft.getNmRelation().toString().compareTo(nextRight.getNmRelation().toString()) < 0 || !rootIdDiffers && nextLeft.getId() < nextRight.getId()) {
                        diffNode = DataDiff.compareImpl(nextLeft, null, rightMissing, false);
                        nextLeft = null;
                    } else if (nextLeft.getNmRelation() != null && nextRight.getNmRelation() != null && nextLeft.getNmRelation().toString().compareTo(nextRight.getNmRelation().toString()) > 0 || !rootIdDiffers && nextLeft.getId() > nextRight.getId()) {
                        diffNode = DataDiff.compareImpl(null, nextRight, rightMissing, false);
                        nextRight = null;
                    } else {
                        diffNode = DataDiff.compareImpl(nextLeft, nextRight, rightMissing, rootIdDiffers);
                        nextLeft = null;
                        nextRight = null;
                    }
                    diffNodes.add(diffNode);
                    different |= !rightMissing && diffNode.different;
                }
            }
        }
        if (diffNodes != null && diffNodes.isEmpty() && (left == null || left instanceof DataObject) && (right == null || right instanceof DataObject)) {
            diffNodes = null;
        }
        return new DataDiff(left, right, different, diffNodes);
    }
}

