/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;

public class DataNodeTreeItem<T extends DataNode>
extends TreeItem<T> {
    private final Predicate<T> predicate;
    private boolean childrenLoaded;

    public DataNodeTreeItem(T node, Predicate<T> predicate) {
        super(node);
        this.predicate = predicate;
    }

    public boolean isLeaf() {
        return this.getValue() == null || ((DataNode)this.getValue()).getNodes() == null;
    }

    public ObservableList<TreeItem<T>> getChildren() {
        if (!this.childrenLoaded) {
            List<? extends DataNode> nodes;
            this.childrenLoaded = true;
            ArrayList<DataNodeTreeItem<DataNode>> childItems = new ArrayList<DataNodeTreeItem<DataNode>>();
            if (this.getValue() != null && (nodes = ((DataNode)this.getValue()).getNodes()) != null) {
                for (DataNode dataNode : nodes) {
                    if (this.predicate != null && !this.predicate.test(dataNode)) continue;
                    childItems.add(new DataNodeTreeItem<DataNode>(dataNode, this.predicate));
                }
            }
            super.getChildren().setAll(childItems);
        }
        return super.getChildren();
    }
}

