/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.tentackle.common.InterruptedRuntimeException;
import org.tentackle.fx.Fx;
import org.tentackle.maven.plugin.wizard.AbstractWizardMojo;
import org.tentackle.maven.plugin.wizard.OperationProfile;
import org.tentackle.maven.plugin.wizard.fx.OperationWizard;

@Mojo(name="operation", aggregator=true)
public class OperationMojo
extends AbstractWizardMojo {
    private List<OperationProfile> operationProfiles;
    private Stage stage;

    @Override
    protected Stage getStage() {
        return this.stage;
    }

    public List<OperationProfile> getOperationProfiles() {
        return this.operationProfiles;
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        super.executeImpl();
        CountDownLatch latch = new CountDownLatch(1);
        Platform.startup(() -> {
            try {
                this.registerUncaughtExceptionHandler();
                OperationWizard wizard = (OperationWizard)Fx.load(OperationWizard.class);
                wizard.applyMojo(this);
                this.stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
                Scene scene = Fx.createScene((Parent)wizard.getView());
                this.stage.setScene(scene);
                this.stage.setTitle("Operation Wizard");
                wizard.getContainer().updateView();
                this.stage.setOnHidden(event -> latch.countDown());
                this.stage.show();
            }
            catch (Throwable t) {
                this.getLog().error(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException((Throwable)e);
        }
    }

    @Override
    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            this.operationProfiles = this.getProfiles(OperationProfile.class);
            if (this.operationProfiles.isEmpty()) {
                throw new MojoExecutionException("at least one OperationProfile must be configured");
            }
            Map packageInfoMap = this.createPackageMap(false);
            for (OperationProfile profile : this.operationProfiles) {
                profile.validate(packageInfoMap);
            }
            return true;
        }
        return false;
    }
}

