/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.List;
import org.tentackle.maven.plugin.wizard.pdodata.DataList;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.maven.plugin.wizard.pdodata.SqlCondition;
import org.tentackle.model.Entity;
import org.tentackle.model.Relation;
import org.tentackle.pdo.PersistentDomainObject;

public class DataObject
implements DataNode {
    private final PersistentDomainObject<?> pdo;
    private final String type;
    private final String name;
    private final List<DataNode> nodes;
    private final String comment;
    private final Entity entity;
    private final Relation relation;
    private final NonCompositeRelation nmRelation;
    private final boolean hidden;
    private final SqlCondition sqlCondition;
    private String configurationPath;
    private DataList dataList;
    private int listIndex;
    private String formattedName;

    public DataObject(PersistentDomainObject<?> pdo, String name, String comment, List<DataNode> nodes, Entity entity, Relation relation, NonCompositeRelation nmRelation, boolean hidden, SqlCondition sqlCondition) {
        this.pdo = pdo;
        this.type = pdo.getEffectiveClass().getSimpleName();
        this.name = name;
        this.comment = comment;
        this.nodes = nodes;
        this.entity = entity;
        this.relation = relation;
        this.nmRelation = nmRelation;
        this.hidden = hidden;
        this.sqlCondition = sqlCondition;
    }

    public PersistentDomainObject<?> getPdo() {
        return this.pdo;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        if (this.formattedName == null) {
            if (this.dataList == null) {
                this.formattedName = this.name;
            } else {
                StringBuilder buf = new StringBuilder();
                if (this.nmRelation != null && this.nmRelation.getRelation().getNmMethodName() != null) {
                    buf.append(this.nmRelation.getRelation().getNmMethodName());
                } else {
                    buf.append(this.name);
                }
                buf.append('[').append(this.listIndex).append(']');
                this.formattedName = buf.toString();
            }
        }
        return this.formattedName;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public SqlCondition getSqlCondition() {
        return this.sqlCondition;
    }

    public long getId() {
        return this.pdo.getId();
    }

    public long getSerial() {
        return this.pdo.getSerial();
    }

    public List<DataNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public NonCompositeRelation getNmRelation() {
        return this.nmRelation;
    }

    @Override
    public String getValue() {
        StringBuilder buf = new StringBuilder();
        if (this.nodes == null) {
            buf.append("<null>");
        } else {
            if (this.pdo.isEmbedded()) {
                buf.append(this.pdo);
            } else {
                buf.append('[').append(this.getId()).append('/').append(this.getSerial()).append(']');
            }
            if (this.nmRelation != null) {
                buf.append(" -> ").append(this.nmRelation);
            }
        }
        return buf.toString();
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Override
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setDataList(DataList dataList, int listIndex) {
        this.dataList = dataList;
        this.listIndex = listIndex;
        this.formattedName = null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type);
        String fmtName = this.getName();
        if (fmtName != null) {
            buf.append(' ').append(fmtName).append(" =");
        }
        buf.append(' ').append(this.getValue());
        return buf.toString();
    }
}

