/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.LinkedHashMap;
import java.util.Map;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataList;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.model.Attribute;
import org.tentackle.model.Relation;
import org.tentackle.sql.datatypes.StringType;

public class CodeConfigurationFactory {
    private final DataObject[] dataObjects;

    public static Map<String, Boolean> createConfig(DataObject ... dataObjects) {
        return new CodeConfigurationFactory(dataObjects).create();
    }

    private CodeConfigurationFactory(DataObject ... dataObjects) {
        this.dataObjects = dataObjects;
    }

    private Map<String, Boolean> create() {
        LinkedHashMap<String, Boolean> configuration = new LinkedHashMap<String, Boolean>();
        String configPath = "";
        for (DataObject dataObject : this.dataObjects) {
            this.analyzeComponent(configuration, configPath, dataObject);
        }
        return configuration;
    }

    private void analyzeComponent(Map<String, Boolean> configuration, String configPath, DataObject component) {
        configPath = this.updatePath(configPath, component);
        if (component.getRelation() != null && component.getRelation().getStereotypes().contains("NOTEST")) {
            configuration.put(configPath, Boolean.FALSE);
        }
        for (DataNode node : component.getNodes()) {
            this.analyzeNode(configuration, configPath, node);
        }
    }

    private void analyzeNode(Map<String, Boolean> configuration, String configPath, DataNode node) {
        if (node instanceof DataItem) {
            DataItem item = (DataItem)node;
            this.analyzeItem(configuration, configPath, item);
        } else if (node instanceof DataObject) {
            DataObject component = (DataObject)node;
            this.analyzeComponent(configuration, configPath, component);
        } else if (node instanceof DataList) {
            DataList list = (DataList)node;
            this.analyzeList(configuration, configPath, list);
        }
    }

    private void analyzeItem(Map<String, Boolean> configuration, String configPath, DataItem item) {
        Attribute attribute = item.getAttribute();
        if (attribute != null) {
            String str;
            Object object;
            configPath = this.updatePath(configPath, item);
            if (attribute.getOptions().getStereotypes().contains("NOTEST")) {
                configuration.put(configPath, Boolean.FALSE);
            } else if (attribute.getDataType() instanceof StringType && (object = item.getOrgValue()) instanceof String && (str = (String)object).contains("\n")) {
                configuration.put(configPath, Boolean.TRUE);
            }
        }
    }

    private void analyzeList(Map<String, Boolean> configuration, String configPath, DataList list) {
        Relation relation = list.getRelation();
        if (relation != null) {
            configPath = this.updatePath(configPath, list);
            if (relation.getStereotypes().contains("NOTEST")) {
                configuration.put(configPath, Boolean.FALSE);
            }
            for (DataObject object : list.getNodes()) {
                if (object.getNmRelation() != null) {
                    configuration.put(configPath, Boolean.TRUE);
                }
                this.analyzeComponent(configuration, configPath, object);
            }
        }
    }

    private String updatePath(String path, DataNode node) {
        String name = node.getName();
        if (name != null && !name.contains("[")) {
            if (!((String)path).isEmpty()) {
                path = (String)path + ".";
            }
            path = (String)path + name;
        }
        node.setConfigurationPath((String)path);
        return path;
    }
}

