/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.List;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.model.Relation;
import org.tentackle.pdo.PersistentDomainObject;

public class DataObject
implements DataNode {
    private final PersistentDomainObject<?> pdo;
    private final String type;
    private final String name;
    private final List<DataNode> nodes;
    private final String comment;
    private final Relation relation;
    private final NonCompositeRelation nmRelation;
    private String configurationPath;

    public DataObject(PersistentDomainObject<?> pdo, String name, String comment, List<DataNode> nodes, Relation relation, NonCompositeRelation nmRelation) {
        this.pdo = pdo;
        this.type = pdo.getEffectiveClass().getSimpleName();
        this.name = name;
        this.comment = comment;
        this.nodes = nodes;
        this.relation = relation;
        this.nmRelation = nmRelation;
    }

    public PersistentDomainObject<?> getPdo() {
        return this.pdo;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public long getId() {
        return this.pdo.getId();
    }

    public long getSerial() {
        return this.pdo.getSerial();
    }

    public List<DataNode> getNodes() {
        return this.nodes;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public NonCompositeRelation getNmRelation() {
        return this.nmRelation;
    }

    @Override
    public String getValue() {
        StringBuilder buf = new StringBuilder();
        if (this.nodes == null) {
            buf.append("<null>");
        } else {
            if (!this.pdo.isEmbedded()) {
                buf.append('[').append(this.getId()).append('/').append(this.getSerial()).append(']');
            }
            if (this.nmRelation != null) {
                buf.append(" -> ").append(this.nmRelation);
            }
        }
        return buf.toString();
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Override
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type);
        if (this.name != null) {
            buf.append(' ').append(this.name).append(" =");
        }
        buf.append(' ').append(this.getValue());
        return buf.toString();
    }
}

