/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import java.util.Map;
import javafx.event.ActionEvent;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.stage.WindowEvent;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.container.FxBorderPane;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.maven.plugin.wizard.fx.DataNodeTableConfiguration;
import org.tentackle.maven.plugin.wizard.pdodata.DataDiff;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.pdo.PersistentDomainObject;

@FxControllerService(url="NONE", resources="NONE")
public class PdoView
extends AbstractFxController {
    private static final String STYLE_MISMATCH = "diff-mismatch";
    @Bindable
    private DataDiff diff;
    private final FxTreeTableView<DataDiff> diffNode = (FxTreeTableView)Fx.create(TreeTableView.class);
    private TablePopup<DataDiff> diffNodePopup;
    private boolean diffOnly;

    public PdoView() {
        this.diffNode.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        FxBorderPane pane = (FxBorderPane)Fx.create(BorderPane.class);
        pane.setCenter(this.diffNode);
        this.setView((Parent)pane);
    }

    public double getPrefWidth() {
        return this.diffNode.getPrefWidth();
    }

    public void configure() {
        this.diffNode.setSortable(false);
        this.diffNode.setReorderable(false);
        this.diffNode.setRowFactory(treeTableView -> new TreeTableRow<DataDiff>(){

            protected void updateItem(DataDiff item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && item.isDifferent()) {
                    if (!this.getStyleClass().contains((Object)PdoView.STYLE_MISMATCH)) {
                        this.getStyleClass().add((Object)PdoView.STYLE_MISMATCH);
                    }
                } else {
                    this.getStyleClass().remove((Object)PdoView.STYLE_MISMATCH);
                }
            }
        });
        this.diffNodePopup = Rdc.createTablePopup(this.diffNode, (String)"dataView", (String)"Data");
        this.diffNodePopup.setColumnMenuEnabled(false);
        this.diffNodePopup.loadPreferences();
        this.configureContextMenu();
    }

    public void setDiff(DataDiff diff, String leftSiteName, String rightSiteName) {
        this.diff = diff;
        if (diff == null || !diff.isRightPresent()) {
            this.diffOnly = false;
            ((DataNodeTableConfiguration)this.diffNode.getConfiguration()).setPredicate(null);
        }
        this.diffNode.updateView();
        ((TreeTableColumn)this.diffNode.getColumns().get(2)).setText(leftSiteName);
        ((TreeTableColumn)this.diffNode.getColumns().get(3)).setText(rightSiteName);
        this.diffNode.getRoot().setExpanded(true);
    }

    private void configureContextMenu() {
        ContextMenu contextMenu = this.diffNode.getContextMenu();
        MenuItem diffOnlyItem = (MenuItem)Fx.create(MenuItem.class);
        diffOnlyItem.setOnAction(this::toggleDiffOnly);
        MenuItem copyFQCNItem = (MenuItem)Fx.create(MenuItem.class);
        copyFQCNItem.setOnAction(this::copyFQCN);
        MenuItem copyTableItem = (MenuItem)Fx.create(MenuItem.class);
        copyTableItem.setOnAction(this::copyTableName);
        MenuItem copyIdItem = (MenuItem)Fx.create(MenuItem.class);
        copyIdItem.setOnAction(this::copyClassId);
        contextMenu.getItems().add(0, (Object)copyIdItem);
        contextMenu.getItems().add(0, (Object)copyTableItem);
        contextMenu.getItems().add(0, (Object)copyFQCNItem);
        contextMenu.getItems().add(0, (Object)diffOnlyItem);
        contextMenu.addEventHandler(WindowEvent.WINDOW_SHOWING, event -> {
            diffOnlyItem.setText(this.diffOnly ? "show all lines" : "show differences only");
            TypeInfo typeInfo = this.getSelectedTypeInfo();
            copyFQCNItem.setVisible(false);
            copyTableItem.setVisible(false);
            copyIdItem.setVisible(false);
            if (typeInfo != null) {
                if (typeInfo.fqcn != null) {
                    copyFQCNItem.setText("copy FQCN \"" + typeInfo.fqcn + "\" to clipboard");
                    copyFQCNItem.setVisible(true);
                }
                if (typeInfo.tableName != null) {
                    copyTableItem.setText("copy table name \"" + typeInfo.tableName + "\" to clipboard");
                    copyTableItem.setVisible(true);
                }
                if (typeInfo.classId != 0L) {
                    copyIdItem.setText("copy class-ID \"" + typeInfo.classId + "\" to clipboard");
                    copyIdItem.setVisible(true);
                }
            }
        });
    }

    private void toggleDiffOnly(ActionEvent event) {
        this.diffOnly = !this.diffOnly;
        this.updateDiffOnly();
    }

    private void updateDiffOnly() {
        if (this.diffOnly) {
            ((DataNodeTableConfiguration)this.diffNode.getConfiguration()).setPredicate(node -> ((DataDiff)node).isDifferent());
        } else {
            ((DataNodeTableConfiguration)this.diffNode.getConfiguration()).setPredicate(null);
        }
        this.diffNode.scrollTo(0);
        this.diffNode.updateView();
        if (this.diffOnly) {
            this.diffNode.expandAll();
        } else {
            this.diffNode.getRoot().setExpanded(true);
        }
    }

    private void copyFQCN(ActionEvent event) {
        TypeInfo typeInfo = this.getSelectedTypeInfo();
        if (typeInfo != null) {
            this.copyToClipboard(typeInfo.fqcn);
        }
    }

    private void copyTableName(ActionEvent event) {
        TypeInfo typeInfo = this.getSelectedTypeInfo();
        if (typeInfo != null) {
            this.copyToClipboard(typeInfo.tableName);
        }
    }

    private void copyClassId(ActionEvent event) {
        TypeInfo typeInfo = this.getSelectedTypeInfo();
        if (typeInfo != null) {
            this.copyToClipboard(Long.toString(typeInfo.classId));
        }
    }

    private TypeInfo getSelectedTypeInfo() {
        TreeItem selectedItem = (TreeItem)this.diffNode.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            DataObject object;
            PersistentDomainObject<?> pdo;
            DataNode data;
            DataDiff diff = (DataDiff)selectedItem.getValue();
            DataNode dataNode = data = diff.isLeftPresent() ? diff.getLeft() : diff.getRight();
            if (data instanceof DataObject && (pdo = (object = (DataObject)data).getPdo()) != null) {
                return new TypeInfo(pdo.getEffectiveClass().getName(), pdo.getTableName(), pdo.getClassId());
            }
        }
        return null;
    }

    private void copyToClipboard(String text) {
        ClipboardContent cbc = new ClipboardContent();
        cbc.putString(text);
        Clipboard.getSystemClipboard().setContent((Map)cbc);
    }

    private record TypeInfo(String fqcn, String tableName, long classId) {
    }
}

