/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.bind.Bindable;
import org.tentackle.common.Timestamp;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.FxComboBox;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.component.Note;
import org.tentackle.fx.container.FxBorderPane;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.container.FxSplitPane;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.maven.plugin.wizard.BrowseMojo;
import org.tentackle.maven.plugin.wizard.PdoProfile;
import org.tentackle.maven.plugin.wizard.fx.PdoType;
import org.tentackle.maven.plugin.wizard.fx.PdoView;
import org.tentackle.maven.plugin.wizard.pdodata.DataDiff;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.JavaCodeFactory;
import org.tentackle.maven.plugin.wizard.pdodata.PdoWrapper;
import org.tentackle.misc.FormatHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.PersistentDomainObject;

@FxControllerService(resources="NONE")
public class PdoBrowser
extends AbstractFxController
implements DomainContextProvider {
    private static final int LATEST_DEFAULT = 100;
    @Bindable
    private int latest = 100;
    @Bindable
    private PdoProfile profile;
    @Bindable
    private boolean rootOnly;
    @Bindable
    private PdoType entity;
    @Bindable
    private List<PdoWrapper> pdos;
    @FXML
    private FxSplitPane splitPane;
    @FXML
    private FxChoiceBox<PdoProfile> profileField;
    @FXML
    private FxCheckBox rootOnlyField;
    @FXML
    private FxComboBox<PdoType> entityField;
    @FXML
    private FxTableView<PdoWrapper> pdosTableView;
    @FXML
    private FxTextField latestField;
    @FXML
    private FxButton refreshButton;
    @FXML
    private FxButton finderButton;
    @FXML
    private FxButton configButton;
    @FXML
    private FxButton generateButton;
    @FXML
    private FxButton memorizeButton;
    @FXML
    private FxButton closeButton;
    private BrowseMojo mojo;
    private DomainContext context;
    private TablePopup<PdoWrapper> pdosTablePopup;
    private DataObject dataObject;
    private DataObject oldDataObject;
    private PdoView pdoView;
    private Timestamp loadingTime;
    private Timestamp memorizeTime;
    private PdoFinder finder;
    private Map<String, Boolean> codeConfiguration;

    public static Stage show(BrowseMojo mojo, DomainContext context) throws MojoExecutionException {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        PdoBrowser diffDialog = (PdoBrowser)Fx.load(PdoBrowser.class);
        Scene scene = Fx.createScene((Parent)diffDialog.getView());
        stage.setScene(scene);
        stage.setTitle("PDO Browser");
        diffDialog.setContext(mojo, context);
        diffDialog.getContainer().updateView();
        stage.show();
        return stage;
    }

    @FXML
    private void initialize() {
        this.pdoView = (PdoView)Fx.load(PdoView.class);
        this.splitPane.getItems().add((Object)this.pdoView.getView());
        this.profileField.addViewToModelListener(this::updateEntityFieldProperties);
        this.rootOnlyField.addViewToModelListener(this::updateEntityFieldProperties);
        this.entityField.setListenerSuppressedIfModelUnchanged(true);
        this.entityField.setVisibleRowCount(25);
        this.entityField.addViewToModelListener(this::run);
        this.latestField.addViewToModelListener(() -> {
            this.finder = null;
            this.run();
        });
        this.refreshButton.setGraphic(Fx.createGraphic((String)"reload"));
        this.refreshButton.setDisable(true);
        this.refreshButton.setOnAction(e -> this.run());
        this.finderButton.setGraphic(Fx.createGraphic((String)"search"));
        this.finderButton.setDisable(true);
        this.finderButton.setFocusTraversable(true);
        this.memorizeButton.setGraphic(Fx.createGraphic((String)"copy"));
        this.memorizeButton.setDisable(true);
        this.memorizeButton.setOnAction(event -> {
            this.oldDataObject = this.dataObject;
            this.memorizeTime = new Timestamp();
            this.showDiff();
        });
        this.configButton.setGraphic(Fx.createGraphic((String)"preferences"));
        this.configButton.setOnAction(e -> this.showCodeConfigurationDialog());
        this.configButton.setDisable(true);
        this.generateButton.setGraphic(Fx.createGraphic((String)"generate"));
        this.generateButton.setDisable(true);
        this.generateButton.setOnAction(e -> this.generateCode());
        this.closeButton.setGraphic(Fx.createGraphic((String)"close"));
        this.closeButton.setOnAction(this::close);
        this.pdosTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.pdosTableView.getSelectionModel().getSelectedItems().addListener(c -> {
            ObservableList selectedItems = c.getList();
            if (selectedItems.isEmpty()) {
                this.dataObject = null;
                this.oldDataObject = null;
                this.memorizeTime = null;
                this.codeConfiguration = null;
                this.configButton.setDisable(true);
                this.generateButton.setDisable(true);
                this.memorizeButton.setDisable(true);
                this.showDiff();
            } else {
                this.dataObject = ((PdoWrapper)selectedItems.get(0)).getDataObject();
                this.memorizeButton.setDisable(false);
                this.generateButton.setDisable(false);
                this.updateCodeConfiguration((List<? extends PdoWrapper>)selectedItems);
                this.showDiff();
            }
        });
    }

    public void configure() {
        this.pdosTablePopup = Rdc.createTablePopup(this.pdosTableView, (String)"pdoView", (String)"PDOs");
        this.pdosTablePopup.setColumnMenuEnabled(false);
        this.pdosTablePopup.loadPreferences();
        double leftWidth = this.pdosTableView.getPrefWidth();
        double totalWidth = this.pdosTableView.getPrefWidth() + this.pdoView.getPrefWidth();
        if (leftWidth >= 1.0 && totalWidth > leftWidth) {
            this.splitPane.setDividerPosition(0, leftWidth / totalWidth);
        }
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public void setContext(BrowseMojo mojo, DomainContext context) throws MojoExecutionException {
        this.mojo = mojo;
        this.context = context;
        this.profileField.getItems().setAll(mojo.getProfiles(PdoProfile.class));
        this.updateEntityFieldProperties();
        this.entityField.requestFocus();
        this.showDiff();
    }

    private void updateCodeConfiguration(List<? extends PdoWrapper> selectedItems) {
        this.codeConfiguration = new LinkedHashMap<String, Boolean>();
        for (PdoWrapper pdoWrapper : selectedItems) {
            this.codeConfiguration.putAll(pdoWrapper.getCodeConfiguration());
        }
        this.configButton.setDisable(this.codeConfiguration.isEmpty());
    }

    private void showDiff() {
        if (this.dataObject != null) {
            this.pdoView.setDiff(DataDiff.compare(this.dataObject, this.oldDataObject), this.loadingTime == null ? "Value" : FormatHelper.formatTimestampFast((Date)this.loadingTime), this.memorizeTime == null ? "" : FormatHelper.formatTimestampFast((Date)this.memorizeTime));
        } else {
            this.pdoView.setDiff(null, "Value", "");
        }
    }

    private void updateEntityFieldProperties() {
        this.entityField.getProperties().put((Object)"rootOnly", (Object)this.rootOnly);
        this.entityField.getProperties().put((Object)"profile", (Object)this.profile);
        this.entityField.getProperties().put((Object)"prefixSelectionEnabled", (Object)"CamelCase");
        Platform.runLater(() -> ((ValueTranslator)this.entityField.getValueTranslator()).bindingPropertiesUpdated());
    }

    private void run() {
        PdoWrapper selectedItem = (PdoWrapper)this.pdosTableView.getSelectionModel().getSelectedItem();
        DataObject savedOldDataObject = this.oldDataObject;
        Timestamp savedMemorizedTime = this.memorizeTime;
        this.pdosTableView.getSelectionModel().clearSelection();
        this.loadingTime = new Timestamp();
        if (this.entity != null) {
            PersistentDomainObject proxy = this.on(this.entity.getClazz());
            if (this.finder != null && this.finder.getPdo().getEffectiveClass() != this.entity.getClazz()) {
                this.finder = null;
            }
            if (this.finder == null) {
                this.pdos = proxy.selectLatest(0L, this.latest).stream().map(PdoWrapper::new).toList();
            }
            this.refreshButton.setDisable(false);
            GuiProvider<?> guiProvider = this.getGuiProvider(proxy);
            if (guiProvider != null && guiProvider.isFinderAvailable()) {
                this.finderButton.setDisable(false);
                this.finderButton.setOnAction(event -> {
                    this.finder = guiProvider.createFinder();
                    this.finder.setPdo(proxy);
                    Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
                    FxBorderPane borderPane = (FxBorderPane)Fx.create(BorderPane.class);
                    borderPane.setPadding(new Insets(10.0));
                    borderPane.setCenter((Node)this.finder.getView());
                    FxHBox hBox = (FxHBox)Fx.create(HBox.class);
                    hBox.setSpacing(10.0);
                    hBox.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
                    hBox.setAlignment(Pos.BASELINE_RIGHT);
                    FxButton cancelButton = (FxButton)Fx.create(Button.class);
                    cancelButton.setText("cancel");
                    cancelButton.setGraphic(Fx.createGraphic((String)"cancel"));
                    cancelButton.setOnAction(e -> {
                        stage.close();
                        this.finder = null;
                        this.run();
                    });
                    FxButton findButton = (FxButton)Fx.create(Button.class);
                    findButton.setText("find");
                    findButton.setGraphic(Fx.createGraphic((String)"search"));
                    findButton.setOnAction(e -> {
                        this.pdos = this.finder.runSearch().stream().map(pdo -> new PdoWrapper((PersistentDomainObject)pdo)).toList();
                        this.pdosTableView.updateView();
                        stage.close();
                    });
                    hBox.getChildren().addAll((Object[])new Node[]{findButton, cancelButton});
                    borderPane.setBottom((Node)hBox);
                    Scene scene = Fx.createScene((Parent)borderPane);
                    stage.setScene(scene);
                    stage.setTitle("Find " + proxy.getPlural());
                    borderPane.updateView();
                    stage.show();
                });
            } else {
                this.finderButton.setDisable(true);
            }
        } else {
            this.pdos = new ArrayList<PdoWrapper>();
            this.refreshButton.setDisable(true);
            this.finderButton.setDisable(true);
            this.finder = null;
        }
        this.pdosTableView.updateView();
        if (selectedItem != null && this.pdos.contains(selectedItem)) {
            this.oldDataObject = savedOldDataObject;
            this.memorizeTime = savedMemorizedTime;
            this.pdosTableView.getSelectionModel().select((Object)selectedItem);
        }
    }

    private void showCodeConfigurationDialog() {
        if (this.codeConfiguration != null) {
            Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
            stage.initOwner((Window)this.getStage());
            BorderPane borderPane = (BorderPane)Fx.create(BorderPane.class);
            ScrollPane scrollPane = (ScrollPane)Fx.create(ScrollPane.class);
            VBox vBox = (VBox)Fx.create(VBox.class);
            vBox.setPadding(new Insets(10.0));
            vBox.setSpacing(5.0);
            scrollPane.setMinWidth(300.0);
            scrollPane.setMinHeight(150.0);
            for (Map.Entry<String, Boolean> entry : this.codeConfiguration.entrySet()) {
                CheckBox checkBox = (CheckBox)Fx.create(CheckBox.class);
                checkBox.setText(entry.getKey());
                checkBox.setSelected(entry.getValue().booleanValue());
                checkBox.setOnAction(e -> entry.setValue(checkBox.isSelected()));
                vBox.getChildren().add((Object)checkBox);
            }
            scrollPane.setContent((Node)vBox);
            borderPane.setCenter((Node)scrollPane);
            HBox hBox = (HBox)Fx.create(HBox.class);
            Button closeButton = (Button)Fx.create(Button.class);
            closeButton.setText("close");
            closeButton.setGraphic(Fx.createGraphic((String)"close"));
            closeButton.setOnAction(event -> stage.close());
            hBox.getChildren().add((Object)closeButton);
            hBox.setPadding(new Insets(10.0));
            hBox.setAlignment(Pos.BASELINE_RIGHT);
            borderPane.setBottom((Node)hBox);
            Scene scene = Fx.createScene((Parent)borderPane);
            stage.setScene(scene);
            stage.setTitle("Code Configuration");
            stage.show();
        }
    }

    private void generateCode() {
        ObservableList selectedItems = this.pdosTableView.getSelectionModel().getSelectedItems();
        if (!selectedItems.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("// generated at ").append(FormatHelper.formatShortTimestampFast((Date)new Timestamp())).append(" by ").append(System.getProperty("user.name")).append('@').append(this.mojo.getHostName()).append(" from ").append(this.getDomainContext().getSession()).append('\n');
            DataObject[] dataObjects = new DataObject[selectedItems.size()];
            int i = 0;
            for (PdoWrapper pdoWrapper : selectedItems) {
                dataObjects[i++] = pdoWrapper.getDataObject();
            }
            String text = JavaCodeFactory.generateCode(this.codeConfiguration, dataObjects);
            buf.append(text);
            ClipboardContent cbc = new ClipboardContent();
            cbc.putString(buf.toString());
            Clipboard.getSystemClipboard().setContent((Map)cbc);
            Note infoNote = (Note)Fx.create(Note.class);
            infoNote.setPosition(Note.Position.TOP);
            String topic = selectedItems.size() > 1 ? selectedItems.size() + " " + this.dataObject.getPdo().getPlural() : this.dataObject.toString();
            infoNote.setText("Java code for " + topic + " copied to clipboard");
            infoNote.setFadeEffect(500.0, 2000.0, 1000.0);
            infoNote.show((Node)this.generateButton);
        }
    }

    private GuiProvider<?> getGuiProvider(PersistentDomainObject proxy) {
        if (GuiProviderFactory.getInstance().isGuiProviderAvailable(proxy.getEffectiveClass())) {
            return GuiProviderFactory.getInstance().createGuiProvider(proxy);
        }
        return null;
    }

    private void close(Event event) {
        this.getStage().hide();
    }
}

