/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javafx.fxml.FXML;
import javafx.scene.Node;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.maven.plugin.wizard.OperationGenerator;
import org.tentackle.maven.plugin.wizard.OperationMojo;
import org.tentackle.maven.plugin.wizard.OperationProfile;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationUtilities;

@FxControllerService(resources="NONE")
public class OperationWizard
extends AbstractFxController {
    @Bindable
    private final OperationGenerator gen = new OperationGenerator();
    @FXML
    private FxChoiceBox<OperationProfile> genProfile;
    @FXML
    private FxTextField genOperationName;
    @FXML
    private FxTextField genSuperOperation;
    @FXML
    private FxCheckBox genAbstractOperation;
    @FXML
    private FxTextField genShortDescription;
    @FXML
    private FxTextArea genLongDescription;
    @FXML
    private FxTextField genDomainInterface;
    @FXML
    private FxTextField genPersistenceInterface;
    @FXML
    private FxTextField genDomainImplementation;
    @FXML
    private FxTextField genPersistenceImplementation;
    @FXML
    private FxCheckBox genRemoteEnabled;
    @FXML
    private FxButton cancel;
    @FXML
    private FxButton generate;

    public OperationWizard() {
        this.gen.setRemoteEnabled(true);
    }

    public void applyMojo(OperationMojo mojo) {
        this.genProfile.getItems().clear();
        List<OperationProfile> profiles = mojo.getOperationProfiles();
        this.genProfile.getItems().addAll(profiles);
        if (!profiles.isEmpty()) {
            this.gen.setProfile(profiles.get(0));
        }
        this.gen.setTemplateDirectory(new File(mojo.getTemplateDir(), "operation"));
        this.gen.setLogger(mojo.getLog());
    }

    public void configure() {
        this.cancel.setGraphic(Fx.createGraphic((String)"cancel"));
        this.generate.setGraphic(Fx.createGraphic((String)"generate"));
        this.genProfile.setDeselectAllowed(Boolean.valueOf(false));
        this.genOperationName.addModelToViewListener(() -> {
            this.genDomainInterface.updateView();
            this.genDomainImplementation.updateView();
            this.genPersistenceInterface.updateView();
            this.genPersistenceImplementation.updateView();
        });
        this.genDomainInterface.addModelToViewListener(() -> ((FxTextField)this.genDomainImplementation).updateView());
        this.genPersistenceInterface.addModelToViewListener(() -> ((FxTextField)this.genPersistenceImplementation).updateView());
        this.cancel.setOnAction(e -> this.close());
        this.generate.setOnAction(e -> {
            Consumer<Boolean> generateIt = ok -> {
                if (ok.booleanValue()) {
                    try {
                        List<ValidationResult> results = this.gen.generate();
                        if (results.isEmpty()) {
                            Fx.info((String)"operation classes generated!").setOnHidden(event -> this.close());
                        } else {
                            Fx.error((String)ValidationUtilities.getInstance().resultsToMessage(results));
                        }
                    }
                    catch (TemplateException | IOException ex) {
                        Fx.error((String)"code generation failed", (Throwable)ex);
                    }
                }
            };
            if (this.gen.getDomainInterface() != null && this.gen.getDomainImplementation() == null) {
                Fx.question((String)"do you really don't want a domain implementation?", (boolean)false, generateIt);
            } else if (this.gen.getPersistenceInterface() != null && this.gen.getPersistenceImplementation() == null) {
                Fx.question((String)"do you really don't want a persistence implementation?", (boolean)false, generateIt);
            } else {
                generateIt.accept(true);
            }
        });
    }

    private void close() {
        Fx.getStage((Node)this.getView()).close();
    }
}

