/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.pdo.PersistentDomainObject;

@TableCellTypeService(value=DataNode.class)
public class DataNodeCellType
extends AbstractTableCellType<DataNode> {
    public void updateItem(FxTableCell<?, DataNode> tableCell, DataNode item) {
        tableCell.setText(this.getName(item));
        tableCell.setGraphic(this.getIcon(item));
        this.updateAlignment(tableCell, Pos.BASELINE_LEFT);
    }

    public void updateItem(FxTreeTableCell<?, DataNode> treeTableCell, DataNode item) {
        treeTableCell.setText(this.getName(item));
        treeTableCell.setGraphic(this.getIcon(item));
        treeTableCell.setTooltip(item.getComment() == null ? null : new Tooltip(item.getComment()));
        this.updateAlignment(treeTableCell, Pos.BASELINE_LEFT);
    }

    private String getName(DataNode item) {
        String name = item.getName();
        if (StringHelper.isAllWhitespace((String)name)) {
            name = StringHelper.firstToLower((String)item.getType());
        }
        return name;
    }

    private Node getIcon(DataNode item) {
        if (item instanceof DataObject) {
            GuiProvider guiProvider;
            PersistentDomainObject<?> pdo = ((DataObject)item).getPdo();
            if (GuiProviderFactory.getInstance().isGuiProviderAvailable(pdo.getEffectiveClass()) && (guiProvider = GuiProviderFactory.getInstance().createGuiProvider(pdo)) != null) {
                return guiProvider.createGraphic();
            }
        }
        return Fx.createGraphic((String)"data", (String)item.getClass().getSimpleName());
    }
}

