/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.log.Logger;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataList;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;
import org.tentackle.maven.plugin.wizard.pdodata.NonCompositeRelation;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.Persistent;

public class DataNodeFactory {
    private static final Logger LOGGER = Logger.get(DataNodeFactory.class);
    private static final String PO_SUFFIX = "PersistenceObject";
    private static final Map<Class<? extends PersistentDomainObject<?>>, ClassInfo> classMap = new ConcurrentHashMap();

    public static DataObject create(PersistentDomainObject<?> pdo) {
        pdo.loadComponents(false);
        return DataNodeFactory.getDataObject(pdo, null, null, null);
    }

    private static DataObject getDataObject(PersistentDomainObject<?> pdo, String name, String comment, PersistentDomainObject<?> parentPdo) {
        int ndx;
        String relationName;
        ClassInfo parentInfo;
        Object relation;
        String entityComment;
        ClassInfo classInfo = classMap.computeIfAbsent(pdo.getEffectiveClass(), ClassInfo::new);
        if ((comment == null || comment.equals(classInfo.entity.getName())) && (entityComment = classInfo.entity.getOptions().getComment()) != null) {
            comment = entityComment;
        }
        ArrayList<DataNode> nodes = new ArrayList<DataNode>();
        for (MethodInfo methodInfo : classInfo.methodInfos) {
            try {
                Object value = methodInfo.getter.invoke(pdo, new Object[0]);
                if (methodInfo.isComponent) {
                    if (methodInfo.isList) {
                        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
                        List components = (List)value;
                        if (components != null) {
                            int ndx2 = 0;
                            for (PersistentDomainObject component : components) {
                                dataObjects.add(DataNodeFactory.createDataObject(methodInfo.name + "[" + ndx2++ + "]", methodInfo.comment, component, pdo));
                            }
                        }
                        relation = classInfo.entity.getRelation(methodInfo.name, true);
                        nodes.add(new DataList(methodInfo.typeName, methodInfo.name, methodInfo.comment, dataObjects, (Relation)relation));
                        continue;
                    }
                    nodes.add(DataNodeFactory.createDataObject(methodInfo.name, methodInfo.comment, (PersistentDomainObject)value, pdo));
                    continue;
                }
                if ("rootId".equals(methodInfo.name) && !pdo.isRootIdProvided() || "rootClassId".equals(methodInfo.name) && !pdo.isRootClassIdProvided() || "tableSerial".equals(methodInfo.name) && !pdo.isTableSerialProvided() || "normText".equals(methodInfo.name) && !pdo.isNormTextProvided() || "editedBy".equals(methodInfo.name) && !pdo.isTokenLockProvided() || "editedSince".equals(methodInfo.name) && !pdo.isTokenLockProvided() || "editedExpiry".equals(methodInfo.name) && !pdo.isTokenLockProvided()) continue;
                boolean idOfCompositeRelation = false;
                NonCompositeRelation nonCompositeRelation = null;
                if ("long".equals(methodInfo.typeName) || "Long".equals(methodInfo.typeName)) {
                    relation = classInfo.entity.getAllRelations().iterator();
                    while (relation.hasNext()) {
                        Attribute attribute;
                        Relation relation2 = (Relation)relation.next();
                        if (relation2.getRelationType() != RelationType.OBJECT || (attribute = relation2.getAttribute()) == null || !attribute.getName().equals(methodInfo.name)) continue;
                        Relation foreignRelation = relation2.getForeignRelation();
                        if (relation2.isComposite() || foreignRelation != null && foreignRelation.isComposite()) {
                            idOfCompositeRelation = true;
                            break;
                        }
                        String getterName = relation2.getGetterName();
                        try {
                            PersistentDomainObject relatedPdo;
                            Method getter = classInfo.pdoClass.getMethod(getterName, new Class[0]);
                            Object getterValue = getter.invoke(pdo, new Object[0]);
                            if (!(getterValue instanceof PersistentDomainObject) || !(relatedPdo = (PersistentDomainObject)getterValue).isUniqueDomainKeyProvided()) continue;
                            nonCompositeRelation = new NonCompositeRelation(relation2, relatedPdo);
                            break;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            LOGGER.warning("cannot load 1:1 relation: " + getterName, (Throwable)e);
                        }
                    }
                }
                Attribute attribute = classInfo.entity.getAttributeByJavaName(methodInfo.name, true);
                nodes.add(new DataItem(methodInfo.typeName, methodInfo.name, value, methodInfo.comment, attribute, idOfCompositeRelation, nonCompositeRelation));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warning("cannot determine method return value", (Throwable)e);
            }
        }
        Relation objectRelation = null;
        NonCompositeRelation nmRelation = null;
        if (parentPdo != null && (parentInfo = classMap.get(parentPdo.getEffectiveClass())) != null && (relation = parentInfo.entity.getRelation(relationName = (ndx = name.indexOf(91)) >= 0 ? name.substring(0, ndx) : name, true)) != null && relation.isComposite()) {
            objectRelation = relation;
            Relation nmRel = relation.getNmRelation();
            if (nmRel != null) {
                String getterName = nmRel.getGetterName();
                try {
                    PersistentDomainObject relatedPdo;
                    Method getter = classInfo.pdoClass.getMethod(getterName, new Class[0]);
                    Object getterValue = getter.invoke(pdo, new Object[0]);
                    if (getterValue instanceof PersistentDomainObject && (relatedPdo = (PersistentDomainObject)getterValue).isUniqueDomainKeyProvided()) {
                        nmRelation = new NonCompositeRelation((Relation)relation, relatedPdo);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.warning("cannot load N:M relation: " + getterName, (Throwable)e);
                }
            }
        }
        return new DataObject(pdo, name, comment, nodes, objectRelation, nmRelation);
    }

    private static DataObject createDataObject(String name, String comment, PersistentDomainObject<?> pdo, PersistentDomainObject<?> parentPdo) {
        DataObject dataObject = pdo == null ? new DataObject(pdo, name, null, null, null, null) : DataNodeFactory.getDataObject(pdo, name, comment, parentPdo);
        return dataObject;
    }

    private static String toTypeName(Class<?> type) {
        String typeName = type.getSimpleName();
        if (PersistentDomainObject.class.isAssignableFrom(type) && typeName.endsWith(PO_SUFFIX)) {
            typeName = typeName.substring(0, typeName.length() - PO_SUFFIX.length());
        }
        return typeName;
    }

    private static Entity lookupEntity(String typeName) {
        try {
            Entity entity = Model.getInstance().getByEntityName(typeName);
            if (entity == null) {
                throw new ModelException("entity " + typeName + " missing in model");
            }
            return entity;
        }
        catch (ModelException e) {
            throw new TentackleRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static class ClassInfo {
        private final Class<? extends PersistentDomainObject<?>> pdoClass;
        private final String typeName;
        private final Entity entity;
        private final Set<MethodInfo> methodInfos;

        private ClassInfo(Class<? extends PersistentDomainObject<?>> pdoClass) {
            this.pdoClass = pdoClass;
            this.typeName = DataNodeFactory.toTypeName(pdoClass);
            this.entity = DataNodeFactory.lookupEntity(this.typeName);
            this.methodInfos = new TreeSet<MethodInfo>();
            for (Method method : pdoClass.getMethods()) {
                Class clz;
                Type typeArg;
                Type[] typeArguments;
                Type genType;
                Persistent annotation;
                boolean isGetter;
                if (method.getParameterCount() != 0 || method.isBridge()) continue;
                String name = method.getName();
                Class type = method.getReturnType();
                boolean bl = isGetter = name.startsWith("get") && Character.isUpperCase(name.charAt(3));
                if (isGetter) {
                    name = StringHelper.firstToLower((String)name.substring(3));
                } else if (name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && (type == Boolean.class || type == Boolean.TYPE)) {
                    name = StringHelper.firstToLower((String)name.substring(2));
                    isGetter = true;
                }
                if (!isGetter || (annotation = method.getAnnotation(Persistent.class)) == null || !annotation.component()) continue;
                boolean isComponent = false;
                boolean isList = false;
                if (PersistentDomainObject.class.isAssignableFrom(type)) {
                    isComponent = true;
                } else if (List.class.isAssignableFrom(type) && (genType = method.getGenericReturnType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genType).getActualTypeArguments()) != null && typeArguments.length == 1 && (typeArg = typeArguments[0]) instanceof Class && PersistentDomainObject.class.isAssignableFrom(clz = (Class)typeArg)) {
                    type = clz;
                    isComponent = true;
                    isList = true;
                }
                this.methodInfos.add(new MethodInfo(name, annotation.comment(), method, type, isComponent, isList));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassInfo classInfo = (ClassInfo)o;
            return this.pdoClass.equals(classInfo.pdoClass);
        }

        public int hashCode() {
            return this.pdoClass.hashCode();
        }
    }

    private static class MethodInfo
    implements Comparable<MethodInfo> {
        private final String name;
        private final String comment;
        private final Method getter;
        private final String typeName;
        private final boolean isComponent;
        private final boolean isList;

        private MethodInfo(String name, String comment, Method getter, Class<?> type, boolean isComponent, boolean isList) {
            this.name = name;
            this.comment = comment;
            this.getter = getter;
            this.isComponent = isComponent;
            this.isList = isList;
            this.typeName = DataNodeFactory.toTypeName(type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(MethodInfo o) {
            int rv = Boolean.compare(this.isComponent, o.isComponent);
            if (rv == 0) {
                rv = this.name.compareTo(o.name);
            }
            return rv;
        }
    }
}

