/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.pdodata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tentackle.bind.Bindable;
import org.tentackle.maven.plugin.wizard.pdodata.DataItem;
import org.tentackle.maven.plugin.wizard.pdodata.DataNode;
import org.tentackle.maven.plugin.wizard.pdodata.DataObject;

public class DataDiff
implements DataNode {
    private final DataNode left;
    private final DataNode right;
    private final boolean different;
    private final List<DataDiff> nodes;

    public DataDiff(DataNode left, DataNode right, boolean different, List<DataDiff> nodes) {
        this.left = left;
        this.right = right;
        this.different = different;
        this.nodes = nodes;
    }

    public DataNode getLeft() {
        return this.left;
    }

    public DataNode getRight() {
        return this.right;
    }

    public boolean isDifferent() {
        return this.different;
    }

    public List<DataDiff> getNodes() {
        return this.nodes;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    @Bindable(ordinal=2)
    public String getType() {
        if (this.left != null) {
            return this.left.getType();
        }
        return this.right.getType();
    }

    @Override
    public String getName() {
        if (this.left != null) {
            return this.left.getName();
        }
        return this.right.getName();
    }

    @Override
    public String getValue() {
        if (this.left != null) {
            return this.left.getValue();
        }
        return this.right.getValue();
    }

    public String toString() {
        if (this.left != null) {
            return this.left.toString();
        }
        return this.right.toString();
    }

    @Override
    public String getNodeType() {
        if (this.left != null) {
            return this.left.getNodeType();
        }
        return this.right.getNodeType();
    }

    @Bindable(ordinal=1)
    public DataNode getNode() {
        if (this.left != null) {
            return this.left;
        }
        return this.right;
    }

    @Bindable(ordinal=3)
    public String getLeftValue() {
        return this.left == null ? null : this.left.getValue();
    }

    @Bindable(ordinal=4)
    public String getRightValue() {
        return this.right == null ? null : this.right.getValue();
    }

    public boolean isLeftPresent() {
        return this.left != null;
    }

    public boolean isRightPresent() {
        return this.right != null;
    }

    @Override
    public void setConfigurationPath(String configurationPath) {
        throw new UnsupportedOperationException("no applicable to diffs");
    }

    @Override
    public String getConfigurationPath() {
        return null;
    }

    public static DataDiff compare(DataObject left, DataObject right) {
        boolean rootIdDiffers = left != null && right != null && left.getId() != right.getId();
        return DataDiff.compareImpl(Objects.requireNonNull(left), right, right == null, rootIdDiffers);
    }

    private static DataDiff compareImpl(DataNode left, DataNode right, boolean rightMissing, boolean rootIdDiffers) {
        boolean different;
        ArrayList<DataDiff> nodes;
        if (left != null && right != null && left.getClass() != right.getClass()) {
            throw new IllegalArgumentException("cannot compare " + left.getClass() + " with " + right.getClass());
        }
        if (left == null && right == null) {
            nodes = null;
            different = false;
        } else if (left instanceof DataItem || right instanceof DataItem) {
            nodes = null;
            if (left != null && right != null) {
                DataItem leftItem = (DataItem)left;
                DataItem rightItem = (DataItem)right;
                different = leftItem.isIdOfCompositeRelation() && rightItem.isIdOfCompositeRelation() || leftItem.getAttribute() != null && leftItem.getAttribute().isImplicit() && rightItem.getAttribute() != null && rightItem.getAttribute().isImplicit() ? false : !Objects.equals(left.getValue(), right.getValue());
            } else {
                different = false;
            }
        } else {
            int rightSize;
            nodes = new ArrayList<DataDiff>();
            List<? extends DataNode> leftNodes = left == null ? null : left.getNodes();
            List<? extends DataNode> rightNodes = right == null ? null : right.getNodes();
            int leftSize = leftNodes == null ? 0 : leftNodes.size();
            int n = rightSize = rightNodes == null ? 0 : rightNodes.size();
            if (left instanceof DataObject || right instanceof DataObject) {
                DataObject leftObject = (DataObject)left;
                DataObject rightObject = (DataObject)right;
                long leftSerial = leftObject == null ? 0L : leftObject.getSerial();
                long rightSerial = rightObject == null ? 0L : rightObject.getSerial();
                different = !rightMissing && leftSerial != rightSerial;
                int size = Math.max(leftSize, rightSize);
                for (int i = 0; i < size; ++i) {
                    DataNode leftNode = i < leftSize ? leftNodes.get(i) : null;
                    DataNode rightNode = i < rightSize ? rightNodes.get(i) : null;
                    DataDiff node = DataDiff.compareImpl(leftNode, rightNode, rightMissing, rootIdDiffers);
                    nodes.add(node);
                    different |= !rightMissing && node.different;
                }
            } else {
                different = false;
                List<? extends DataNode> leftObjects = leftNodes;
                List<? extends DataNode> rightObjects = rightNodes;
                int leftIndex = 0;
                int rightIndex = 0;
                DataObject nextLeft = null;
                DataObject nextRight = null;
                while (true) {
                    DataDiff node;
                    if (nextLeft == null && leftIndex < leftSize) {
                        nextLeft = (DataObject)leftObjects.get(leftIndex++);
                    }
                    if (nextRight == null && rightIndex < rightSize) {
                        nextRight = (DataObject)rightObjects.get(rightIndex++);
                    }
                    if (nextLeft == null && nextRight == null) break;
                    if (nextLeft == null) {
                        node = DataDiff.compareImpl(null, nextRight, rightMissing, rootIdDiffers);
                        nextRight = null;
                    } else if (nextRight == null) {
                        node = DataDiff.compareImpl(nextLeft, null, rightMissing, rootIdDiffers);
                        nextLeft = null;
                    } else if (!rootIdDiffers && nextLeft.getId() < nextRight.getId()) {
                        node = DataDiff.compareImpl(nextLeft, null, rightMissing, rootIdDiffers);
                        nextLeft = null;
                    } else if (!rootIdDiffers && nextLeft.getId() > nextRight.getId()) {
                        node = DataDiff.compareImpl(null, nextRight, rightMissing, rootIdDiffers);
                        nextRight = null;
                    } else {
                        node = DataDiff.compareImpl(nextLeft, nextRight, rightMissing, rootIdDiffers);
                        nextLeft = null;
                        nextRight = null;
                    }
                    nodes.add(node);
                    different |= !rightMissing && node.different;
                }
            }
        }
        if (nodes != null && nodes.isEmpty() && (left == null || left instanceof DataObject) && (right == null || right instanceof DataObject)) {
            nodes = null;
        }
        return new DataDiff(left, right, different, nodes);
    }
}

