/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tentackle.bind.Bindable;
import org.tentackle.common.Settings;
import org.tentackle.fx.Fx;
import org.tentackle.maven.GeneratedFile;
import org.tentackle.maven.plugin.wizard.AbstractValidateableGenerator;
import org.tentackle.maven.plugin.wizard.PdoProfile;
import org.tentackle.maven.plugin.wizard.PdoTemplateModel;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.scope.InteractiveScope;
import org.tentackle.validate.validator.Changeable;
import org.tentackle.validate.validator.GreaterOrEqual;
import org.tentackle.validate.validator.NotNull;
import org.tentackle.validate.validator.True;

public class PdoGenerator
extends AbstractValidateableGenerator {
    private File statusDir;
    private PdoProfile profile;
    private String entityName;
    private Integer classId;
    private String tableName;
    private Entity superEntity;
    private InheritanceType inheritanceType;
    private String shortDescription;
    private String longDescription;
    private String domainInterface;
    private String persistenceInterface;
    private String domainImplementation;
    private String persistenceImplementation;
    private boolean remoteEnabled;

    public void setStatusDir(File statusDir) {
        this.statusDir = statusDir;
    }

    public List<ValidationResult> generate() throws IOException, TemplateException {
        List results = this.validate(null, (ValidationScope)ValidationScopeFactory.getInstance().getMandatoryScope());
        results.addAll(this.validate(null, (ValidationScope)ValidationScopeFactory.getInstance().getInteractiveScope()));
        if (results.isEmpty()) {
            Configuration cfg = this.createFreemarkerConfiguration();
            PdoTemplateModel templateModel = new PdoTemplateModel(this);
            ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
            generatedFiles.add(new GeneratedFile(cfg, (Map)((Object)templateModel), "PdoInterface.ftl", new File(this.getProfile().getPdoPackageInfo().getPath(), this.getEntityName() + ".java")));
            generatedFiles.add(new GeneratedFile(cfg, (Map)((Object)templateModel), "DomainInterface.ftl", new File(this.getProfile().getDomainPackageInfo().getPath(), this.getDomainInterface() + ".java")));
            generatedFiles.add(new GeneratedFile(cfg, (Map)((Object)templateModel), "PersistenceInterface.ftl", new File(this.getProfile().getPersistencePackageInfo().getPath(), this.getPersistenceInterface() + ".java")));
            if (this.getDomainImplementation() != null) {
                generatedFiles.add(new GeneratedFile(cfg, (Map)((Object)templateModel), "DomainImplementation.ftl", new File(this.getProfile().getDomainImplPackageInfo().getPath(), this.getDomainImplementation() + ".java")));
            }
            if (this.getPersistenceImplementation() != null) {
                generatedFiles.add(new GeneratedFile(cfg, (Map)((Object)templateModel), "PersistenceImplementation.ftl", new File(this.getProfile().getPersistenceImplPackageInfo().getPath(), this.getPersistenceImplementation() + ".java")));
            }
            for (GeneratedFile generatedFile : generatedFiles) {
                generatedFile.generate();
            }
            if (this.classId != null) {
                this.statusDir.mkdirs();
                try (FileWriter statusWriter = new FileWriter(new File(this.statusDir, this.profile.getName() + ".classid"), Settings.getEncodingCharset());){
                    statusWriter.append(Integer.toString(this.classId + 1));
                }
            }
        }
        return results;
    }

    public boolean isNewEntity() {
        try {
            return this.entityName == null || Model.getInstance().getByEntityName(this.entityName) == null;
        }
        catch (ModelException e) {
            Fx.error((String)"cannot check for duplicate entity", (Throwable)e);
            return true;
        }
    }

    public boolean isNewClassId() {
        if (this.classId != null && this.classId > 0) {
            try {
                for (Entity entity : Model.getInstance().getAllEntities()) {
                    if (entity.getClassId() != this.classId.intValue()) continue;
                    return false;
                }
            }
            catch (ModelException e) {
                Fx.error((String)"cannot check for duplicate entity", (Throwable)e);
            }
        }
        return true;
    }

    public boolean isClassIdNecessary() {
        boolean necessary;
        boolean bl = necessary = InheritanceType.NONE == this.inheritanceType;
        if (!necessary) {
            this.classId = null;
        }
        return necessary;
    }

    public boolean isNewTableName() {
        if (this.tableName != null) {
            try {
                for (Entity entity : Model.getInstance().getAllEntities()) {
                    if (!this.tableName.equalsIgnoreCase(entity.getTableName())) continue;
                    return false;
                }
            }
            catch (ModelException e) {
                Fx.error((String)"cannot check for duplicate entity", (Throwable)e);
            }
        }
        return true;
    }

    public boolean isTableNameNecessary() {
        boolean necessary = false;
        if (this.inheritanceType != null) {
            switch (this.inheritanceType) {
                case NONE: {
                    necessary = this.superEntity == null || this.superEntity.getInheritanceType().isMappingToNoTable() || this.superEntity.getInheritanceType().isMappingToOwnTable();
                    break;
                }
                case SINGLE: {
                    necessary = this.superEntity == null;
                    break;
                }
                case MULTI: {
                    necessary = true;
                }
            }
        }
        if (!necessary) {
            this.tableName = null;
        }
        return necessary;
    }

    public Boolean isTableNameValid() {
        return this.tableName != null && (this.profile == null || this.profile.getTablePrefix() == null || !this.tableName.equals(this.profile.getTablePrefix())) ? Boolean.TRUE : null;
    }

    public boolean isInheritanceTypeValid() {
        return InheritanceType.NONE == this.inheritanceType || this.superEntity == null || this.superEntity.getInheritanceType() == this.inheritanceType;
    }

    @Bindable
    @NotNull
    public PdoProfile getProfile() {
        return this.profile;
    }

    @Bindable
    public void setProfile(PdoProfile profile) {
        if (this.isTableNameNecessary()) {
            String oldPrefix;
            if (this.profile != null && (oldPrefix = this.profile.getTablePrefix()) != null && this.tableName != null && this.tableName.startsWith(oldPrefix)) {
                this.tableName = this.tableName.substring(oldPrefix.length());
                if (this.tableName.isEmpty()) {
                    this.tableName = null;
                }
            }
            if (profile != null && profile.getTablePrefix() != null) {
                this.tableName = this.tableName == null ? profile.getTablePrefix() : profile.getTablePrefix() + this.tableName;
            }
        }
        this.profile = profile;
    }

    @Bindable
    @NotNull(message="missing entity name")
    @True(value="$isNewEntity", scope={InteractiveScope.class}, message="entity already exists")
    public String getEntityName() {
        return this.entityName;
    }

    @Bindable
    public void setEntityName(String entityName) {
        this.entityName = entityName;
        if (entityName == null) {
            this.domainInterface = null;
            this.domainImplementation = null;
            this.persistenceInterface = null;
            this.persistenceImplementation = null;
        } else {
            if (this.domainInterface == null || this.domainInterface.endsWith("Domain")) {
                this.domainInterface = entityName + "Domain";
            }
            if (this.domainImplementation == null || this.domainImplementation.endsWith("DomainImpl")) {
                this.domainImplementation = entityName + "DomainImpl";
            }
            if (this.persistenceInterface == null || this.persistenceInterface.endsWith("Persistence")) {
                this.persistenceInterface = entityName + "Persistence";
            }
            if (this.persistenceImplementation == null || this.persistenceImplementation.endsWith("PersistenceImpl")) {
                this.persistenceImplementation = entityName + "PersistenceImpl";
            }
        }
    }

    @Bindable
    @True(value="$isNewClassId", scope={InteractiveScope.class}, message="class ID already in use")
    @Changeable(condition="$isClassIdNecessary")
    @GreaterOrEqual(value="100", condition="$isClassIdNecessary", message="class IDs below 100 are reserved for tentackle", scope={InteractiveScope.class})
    @NotNull(condition="$isClassIdNecessary", message="missing class ID")
    public Integer getClassId() {
        if (this.isClassIdNecessary() && (this.classId == null || this.classId < this.profile.getMinClassId() || this.classId > this.profile.getMaxClassId())) {
            this.classId = this.profile.getMinClassId();
        }
        return this.classId;
    }

    @Bindable
    public void setClassId(Integer classId) {
        this.classId = classId;
    }

    @Bindable(options="lc")
    @True(value="$isNewTableName", scope={InteractiveScope.class}, message="table name already in use")
    @Changeable(condition="$isTableNameNecessary")
    @NotNull(value="$isTableNameValid", condition="$isTableNameNecessary", message="missing table name")
    public String getTableName() {
        if (this.isTableNameNecessary() && this.tableName == null && this.profile != null && this.profile.getTablePrefix() != null) {
            this.tableName = this.profile.getTablePrefix();
        }
        return this.tableName;
    }

    @Bindable
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Bindable
    public Entity getSuperEntity() {
        return this.superEntity;
    }

    @Bindable
    public void setSuperEntity(Entity superEntity) {
        this.superEntity = superEntity;
    }

    @Bindable
    @NotNull
    @True(value="$isInheritanceTypeValid", scope={InteractiveScope.class}, message="inheritance type does not match super entity")
    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    @Bindable
    public void setInheritanceType(InheritanceType inheritanceType) {
        this.inheritanceType = inheritanceType;
    }

    @Bindable
    @NotNull(message="missing short description")
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Bindable
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Bindable
    public String getLongDescription() {
        return this.longDescription;
    }

    @Bindable
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Bindable
    @NotNull(message="missing domain interface")
    public String getDomainInterface() {
        return this.domainInterface;
    }

    @Bindable
    public void setDomainInterface(String domainInterface) {
        this.domainInterface = domainInterface;
    }

    @Bindable
    @NotNull(message="missing persistence interface")
    public String getPersistenceInterface() {
        return this.persistenceInterface;
    }

    @Bindable
    public void setPersistenceInterface(String persistenceInterface) {
        this.persistenceInterface = persistenceInterface;
    }

    @Bindable
    public String getDomainImplementation() {
        return this.domainImplementation;
    }

    @Bindable
    public void setDomainImplementation(String domainImplementation) {
        this.domainImplementation = domainImplementation;
    }

    @Bindable
    public String getPersistenceImplementation() {
        return this.persistenceImplementation;
    }

    @Bindable
    public void setPersistenceImplementation(String persistenceImplementation) {
        this.persistenceImplementation = persistenceImplementation;
    }

    @Bindable
    public boolean isRemoteEnabled() {
        return this.remoteEnabled;
    }

    @Bindable
    public void setRemoteEnabled(boolean remoteEnabled) {
        this.remoteEnabled = remoteEnabled;
    }

    public String getSuperPdoInterface() {
        String superPdoInterface = this.superEntity != null ? this.superEntity.getName() : (this.profile.getPdoInterface() != null ? this.profile.getPdoInterface() : "PersistentDomainObject");
        return superPdoInterface;
    }

    public String getSuperDomainInterface() {
        Object superDomainInterface = this.superEntity != null ? this.superEntity.getName() + "Domain" : (this.profile.getDomainInterface() != null ? this.profile.getDomainInterface() : "DomainObject");
        return superDomainInterface;
    }

    public String getSuperPersistenceInterface() {
        Object superPersistenceInterface = this.superEntity != null ? this.superEntity.getName() + "Persistence" : (this.profile.getPersistenceInterface() != null ? this.profile.getPersistenceInterface() : "PersistentObject");
        return superPersistenceInterface;
    }

    public String getSuperDomainImplementation() {
        Object superDomainImplementation = this.superEntity != null ? this.superEntity.getName() + "DomainImpl" : (this.profile.getDomainImplementation() != null ? this.profile.getDomainImplementation() : "AbstractDomainObject");
        return superDomainImplementation;
    }

    public String getSuperPersistenceImplementation() {
        Object superPersistenceImplementation = this.superEntity != null ? this.superEntity.getName() + "PersistenceImpl" : (this.profile.getPersistenceImplementation() != null ? this.profile.getPersistenceImplementation() : "AbstractPersistentObject");
        return superPersistenceImplementation;
    }
}

