/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.tentackle.fx.Fx;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.plugin.wizard.Profile;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;

public abstract class AbstractWizardMojo
extends AbstractTentackleMojo {
    @Parameter(defaultValue="${project.build.directory}/wurbel/model", property="tentackle.modelDir")
    protected File modelDir;
    @Parameter(defaultValue="${project.build.directory}/wizard")
    private File statusDir;
    @Parameter(property="tentackle.modelDefaults")
    protected String modelDefaults;
    @Parameter(property="tentackle.entityAliases")
    protected String entityAliases;
    @Parameter
    protected List<FileSet> filesets;
    @Parameter(required=true)
    private List<Profile> profiles;
    @Parameter(defaultValue="${project.basedir}/templates")
    private File templateDir;
    @Parameter(defaultValue="true")
    private boolean loadModelFromDependencies;

    public <T extends Profile> List<T> getProfiles(Class<T> clazz) throws MojoExecutionException {
        ArrayList<Profile> list = new ArrayList<Profile>();
        for (Profile profile : this.profiles) {
            if (!clazz.isAssignableFrom(profile.getClass())) continue;
            if (list.contains(profile)) {
                throw new MojoExecutionException("profile " + profile + " configured more than once");
            }
            list.add(profile);
        }
        return list;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public File getStatusDir() {
        return this.statusDir;
    }

    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.loadModel();
    }

    protected ModelDefaults getModelDefaults() throws MojoExecutionException {
        if (this.modelDefaults == null) {
            return null;
        }
        try {
            return new ModelDefaults(this.modelDefaults);
        }
        catch (ModelException mex) {
            throw new MojoExecutionException(mex.getMessage(), (Exception)((Object)mex));
        }
    }

    protected EntityAliases getEntityAliases() throws MojoExecutionException {
        if (this.entityAliases == null) {
            return null;
        }
        try {
            return new EntityAliases(this.entityAliases);
        }
        catch (ModelException mex) {
            throw new MojoExecutionException(mex.getMessage(), (Exception)((Object)mex));
        }
    }

    protected void loadModel() throws MojoFailureException, MojoExecutionException {
        int errors = 0;
        if (this.loadModelFromDependencies) {
            try {
                Model.getInstance().loadFromResources(true);
            }
            catch (ModelException e) {
                throw new MojoFailureException((Throwable)e);
            }
        }
        if (this.filesets != null && !this.filesets.isEmpty()) {
            for (FileSet fileSet : this.filesets) {
                errors += this.processFileSet(fileSet);
            }
        } else {
            String[] files;
            String[] stringArray = files = this.modelDir.isDirectory() ? this.modelDir.list() : null;
            if (files != null && files.length > 0) {
                FileSet fs = new FileSet();
                fs.setDirectory(this.modelDir.getPath());
                errors += this.processFileSet(fs);
            } else {
                this.getLog().warn((CharSequence)((this.modelDir.exists() ? "empty modelDir " : "no modelDir ") + this.modelDir.getAbsolutePath()));
            }
        }
        if (errors > 0) {
            throw new MojoFailureException(errors + " model errors");
        }
        try {
            this.getLog().info((CharSequence)(Model.getInstance().getAllEntities().size() + " entities loaded"));
        }
        catch (ModelException e) {
            throw new MojoExecutionException("cannot determine entities", (Exception)((Object)e));
        }
    }

    protected int processFileSet(FileSet fileSet) throws MojoExecutionException {
        int errors = 0;
        if (fileSet.getDirectory() == null) {
            fileSet.setDirectory(this.modelDir.getAbsolutePath());
        }
        File dir = new File(fileSet.getDirectory());
        String modelDirName = dir.getPath();
        try {
            Model model = Model.getInstance();
            model.setModelDefaults(this.getModelDefaults());
            model.setEntityAliases(this.getEntityAliases());
            Model.getInstance().loadFromDirectory(modelDirName, true);
        }
        catch (ModelException mex) {
            this.getLog().error((CharSequence)("parsing model failed in directory " + modelDirName + ":\n" + mex.getMessage()));
            ++errors;
        }
        return errors;
    }

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            if (this.templateDir.exists()) {
                if (!this.templateDir.isDirectory()) {
                    throw new MojoExecutionException(this.templateDir.getPath() + " is not a directory");
                }
            } else {
                this.templateDir.mkdirs();
                this.getLog().info((CharSequence)("template directory created: " + this.templateDir.getPath()));
                this.installTemplates();
            }
            return true;
        }
        return false;
    }

    protected void installTemplates() throws MojoExecutionException {
        this.installTemplate("pdo", "DomainImplementation.ftl");
        this.installTemplate("pdo", "DomainInterface.ftl");
        this.installTemplate("pdo", "PdoInterface.ftl");
        this.installTemplate("pdo", "PersistenceImplementation.ftl");
        this.installTemplate("pdo", "PersistenceInterface.ftl");
        this.installTemplate("operation", "DomainImplementation.ftl");
        this.installTemplate("operation", "DomainInterface.ftl");
        this.installTemplate("operation", "OperationInterface.ftl");
        this.installTemplate("operation", "PersistenceImplementation.ftl");
        this.installTemplate("operation", "PersistenceInterface.ftl");
    }

    private void installTemplate(String category, String template) throws MojoExecutionException {
        File dir = new File(this.templateDir, category);
        dir.mkdirs();
        File file = new File(dir, template);
        String path = "/templates/" + category + "/" + template;
        String text = this.loadResourceFileIntoString(path);
        try (PrintStream ps = new PrintStream(new FileOutputStream(file));){
            ps.print(text);
            this.getLog().info((CharSequence)("installed " + category + "-template " + template));
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot install template " + path, (Exception)e);
        }
    }

    protected void registerUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        Thread.currentThread().setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
    }

    private Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (t, e) -> {
            this.getLog().error((CharSequence)"unhandled exception detected", e);
            Platform.runLater(() -> Fx.error((String)e.getMessage(), (Throwable)e, (String)"UNEXPECTED EXCEPTION"));
        };
    }
}

