/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard.fx;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.maven.plugin.wizard.PdoGenerator;
import org.tentackle.maven.plugin.wizard.PdoMojo;
import org.tentackle.maven.plugin.wizard.PdoProfile;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationUtilities;

@FxControllerService(resources="NONE")
public class PdoWizard
extends AbstractFxController {
    @Bindable
    private final PdoGenerator gen = new PdoGenerator();
    @FXML
    private FxChoiceBox<PdoProfile> genProfile;
    @FXML
    private FxTextField genEntityName;
    @FXML
    private FxTextField genClassId;
    @FXML
    private FxTextField genTableName;
    @FXML
    private FxChoiceBox<Entity> genSuperEntity;
    @FXML
    private FxChoiceBox<InheritanceType> genInheritanceType;
    @FXML
    private FxTextField genShortDescription;
    @FXML
    private FxTextArea genLongDescription;
    @FXML
    private FxTextField genDomainInterface;
    @FXML
    private FxTextField genPersistenceInterface;
    @FXML
    private FxTextField genDomainImplementation;
    @FXML
    private FxTextField genPersistenceImplementation;
    @FXML
    private FxCheckBox genRemoteEnabled;
    @FXML
    private FxButton cancel;
    @FXML
    private FxButton generate;

    public PdoWizard() {
        this.gen.setInheritanceType(InheritanceType.NONE);
        this.gen.setRemoteEnabled(true);
    }

    public void applyMojo(PdoMojo mojo) {
        this.genProfile.getItems().clear();
        List<PdoProfile> profiles = mojo.getPdoProfiles();
        this.genProfile.getItems().addAll(profiles);
        if (!profiles.isEmpty()) {
            this.gen.setProfile(profiles.get(0));
        }
        this.gen.setTemplateDirectory(new File(mojo.getTemplateDir(), "pdo"));
        this.gen.setStatusDir(mojo.getStatusDir());
        this.gen.setLogger(mojo.getLog());
    }

    public void configure() {
        try {
            for (Entity entity : Model.getInstance().getAllEntitites()) {
                if (!entity.isAbstract()) continue;
                this.genSuperEntity.getItems().add((Object)entity);
            }
        }
        catch (ModelException e2) {
            Fx.error((String)"cannot load super entities", (Throwable)e2);
        }
        this.genProfile.setDeselectAllowed(Boolean.valueOf(false));
        this.genInheritanceType.setDeselectAllowed(Boolean.valueOf(false));
        this.genProfile.addViewToModelListener(() -> {
            this.genTableName.updateView();
            this.genClassId.updateView();
        });
        this.genEntityName.addModelToViewListener(() -> {
            this.genDomainInterface.updateView();
            this.genDomainImplementation.updateView();
            this.genPersistenceInterface.updateView();
            this.genPersistenceImplementation.updateView();
        });
        this.genInheritanceType.addViewToModelListener(this::updateViewOfClassIdAndTableName);
        this.genSuperEntity.addViewToModelListener(this::updateViewOfClassIdAndTableName);
        this.genTableName.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.gen.getProfile() != null && this.gen.getProfile().getTablePrefix() != null && this.gen.getProfile().getTablePrefix().equals(this.gen.getTableName())) {
                Platform.runLater(() -> this.genTableName.positionCaret(this.gen.getTableName().length()));
            }
        });
        this.cancel.setOnAction(e -> this.close());
        this.generate.setOnAction(e -> {
            Consumer<Boolean> generateIt = ok -> {
                if (ok.booleanValue()) {
                    try {
                        List<ValidationResult> results = this.gen.generate();
                        if (results.isEmpty()) {
                            Fx.info((String)"PDO classes generated!").setOnHidden(event -> this.close());
                        } else {
                            Fx.error((String)ValidationUtilities.getInstance().resultsToMessage(results));
                        }
                    }
                    catch (TemplateException | IOException ex) {
                        Fx.error((String)"code generation failed", (Throwable)ex);
                    }
                }
            };
            if (this.gen.getDomainImplementation() == null && this.gen.getPersistenceImplementation() != null) {
                Fx.question((String)"do you really don't want a domain implementation?", (boolean)false, generateIt);
            } else if (this.gen.getPersistenceImplementation() == null && this.gen.getDomainImplementation() != null) {
                Fx.question((String)"do you really don't want a persistence implementation?", (boolean)false, generateIt);
            } else if (this.gen.getDomainImplementation() == null && this.gen.getPersistenceImplementation() == null) {
                Fx.question((String)"do you really don't want the implementation files?", (boolean)false, generateIt);
            } else {
                generateIt.accept(true);
            }
        });
    }

    private void close() {
        Fx.getStage((Node)this.getView()).close();
    }

    private void updateViewOfClassIdAndTableName() {
        this.genClassId.updateView();
        this.genTableName.updateView();
    }
}

