/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tentackle.bind.Bindable;
import org.tentackle.maven.GeneratedFile;
import org.tentackle.maven.plugin.wizard.AbstractValidateableGenerator;
import org.tentackle.maven.plugin.wizard.OperationProfile;
import org.tentackle.maven.plugin.wizard.OperationTemplateModel;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.validator.Changeable;
import org.tentackle.validate.validator.NotNull;

public class OperationGenerator
extends AbstractValidateableGenerator {
    private OperationProfile profile;
    private String operationName;
    private String superOperationName;
    private String shortDescription;
    private String longDescription;
    private String domainInterface;
    private String persistenceInterface;
    private String domainImplementation;
    private String persistenceImplementation;
    private boolean abstractOperation;
    private boolean remoteEnabled;

    public List<ValidationResult> generate() throws IOException, TemplateException {
        List<ValidationResult> results = this.validate(null, (ValidationScope)ValidationScopeFactory.getInstance().getMandatoryScope());
        results.addAll(this.validate(null, (ValidationScope)ValidationScopeFactory.getInstance().getInteractiveScope()));
        if (results.isEmpty()) {
            Configuration cfg = this.createFreemarkerConfiguration();
            OperationTemplateModel templateModel = new OperationTemplateModel(this);
            ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
            generatedFiles.add(new GeneratedFile(cfg, (Map)templateModel, "OperationInterface.ftl", new File(this.getProfile().getOperationPackageInfo().getPath(), this.getOperationName() + ".java")));
            if (this.getDomainInterface() != null) {
                generatedFiles.add(new GeneratedFile(cfg, (Map)templateModel, "DomainInterface.ftl", new File(this.getProfile().getDomainPackageInfo().getPath(), this.getDomainInterface() + ".java")));
            }
            if (this.getPersistenceInterface() != null) {
                generatedFiles.add(new GeneratedFile(cfg, (Map)templateModel, "PersistenceInterface.ftl", new File(this.getProfile().getPersistencePackageInfo().getPath(), this.getPersistenceInterface() + ".java")));
            }
            if (this.getDomainImplementation() != null) {
                generatedFiles.add(new GeneratedFile(cfg, (Map)templateModel, "DomainImplementation.ftl", new File(this.getProfile().getDomainImplPackageInfo().getPath(), this.getDomainImplementation() + ".java")));
            }
            if (this.getPersistenceImplementation() != null) {
                generatedFiles.add(new GeneratedFile(cfg, (Map)templateModel, "PersistenceImplementation.ftl", new File(this.getProfile().getPersistenceImplPackageInfo().getPath(), this.getPersistenceImplementation() + ".java")));
            }
            for (GeneratedFile generatedFile : generatedFiles) {
                generatedFile.generate();
            }
        }
        return results;
    }

    public boolean isDomainValid() {
        return this.domainInterface != null;
    }

    public boolean isPersistenceValid() {
        return this.persistenceInterface != null;
    }

    @Bindable
    @NotNull
    public OperationProfile getProfile() {
        return this.profile;
    }

    @Bindable
    public void setProfile(OperationProfile profile) {
        this.profile = profile;
    }

    @Bindable
    @NotNull(message="missing operation name")
    public String getOperationName() {
        return this.operationName;
    }

    @Bindable
    public void setOperationName(String operationName) {
        this.operationName = operationName;
        if (operationName == null) {
            this.domainInterface = null;
            this.domainImplementation = null;
            this.persistenceInterface = null;
            this.persistenceImplementation = null;
        } else {
            if (this.domainInterface == null || this.domainInterface.endsWith("Domain")) {
                this.domainInterface = operationName + "Domain";
            }
            if (this.domainImplementation == null || this.domainImplementation.endsWith("DomainImpl")) {
                this.domainImplementation = operationName + "DomainImpl";
            }
            if (this.persistenceInterface == null || this.persistenceInterface.endsWith("Persistence")) {
                this.persistenceInterface = operationName + "Persistence";
            }
            if (this.persistenceImplementation == null || this.persistenceImplementation.endsWith("PersistenceImpl")) {
                this.persistenceImplementation = operationName + "PersistenceImpl";
            }
        }
    }

    @Bindable
    public String getSuperOperationName() {
        return this.superOperationName;
    }

    @Bindable
    public void setSuperOperationName(String superOperationName) {
        this.superOperationName = superOperationName;
    }

    @Bindable
    public boolean isAbstractOperation() {
        return this.abstractOperation;
    }

    @Bindable
    public void setAbstractOperation(boolean abstractOperation) {
        this.abstractOperation = abstractOperation;
    }

    @Bindable
    @NotNull(message="missing short description")
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Bindable
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Bindable
    public String getLongDescription() {
        return this.longDescription;
    }

    @Bindable
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Bindable
    @NotNull(message="missing domain interface", condition="!$isPersistenceValid")
    public String getDomainInterface() {
        return this.domainInterface;
    }

    @Bindable
    public void setDomainInterface(String domainInterface) {
        this.domainInterface = domainInterface;
        if (domainInterface == null) {
            this.domainImplementation = null;
        } else if (this.domainImplementation == null || this.domainImplementation.endsWith("DomainImpl")) {
            this.domainImplementation = this.operationName + "DomainImpl";
        }
    }

    @Bindable
    @NotNull(message="missing persistence interface", condition="!$isDomainValid")
    public String getPersistenceInterface() {
        return this.persistenceInterface;
    }

    @Bindable
    public void setPersistenceInterface(String persistenceInterface) {
        this.persistenceInterface = persistenceInterface;
        if (persistenceInterface == null) {
            this.persistenceImplementation = null;
        } else if (this.persistenceImplementation == null || this.persistenceImplementation.endsWith("PersistenceImpl")) {
            this.persistenceImplementation = this.operationName + "PersistenceImpl";
        }
    }

    @Bindable
    @Changeable(condition="$isDomainValid")
    public String getDomainImplementation() {
        return this.domainImplementation;
    }

    @Bindable
    public void setDomainImplementation(String domainImplementation) {
        this.domainImplementation = domainImplementation;
    }

    @Bindable
    @Changeable(condition="$isPersistenceValid")
    public String getPersistenceImplementation() {
        return this.persistenceImplementation;
    }

    @Bindable
    public void setPersistenceImplementation(String persistenceImplementation) {
        this.persistenceImplementation = persistenceImplementation;
    }

    @Bindable
    public boolean isRemoteEnabled() {
        return this.remoteEnabled;
    }

    @Bindable
    public void setRemoteEnabled(boolean remoteEnabled) {
        this.remoteEnabled = remoteEnabled;
    }

    public String getSuperOperationInterface() {
        String superOperationInterface = this.superOperationName != null ? this.superOperationName : (this.profile.getOperationInterface() != null ? this.profile.getOperationInterface() : "Operation");
        return superOperationInterface;
    }

    public String getSuperDomainInterface() {
        Object superDomainInterface = this.superOperationName != null ? this.superOperationName + "Domain" : (this.profile.getDomainInterface() != null ? this.profile.getDomainInterface() : "DomainOperation");
        return superDomainInterface;
    }

    public String getSuperPersistenceInterface() {
        Object superPersistenceInterface = this.superOperationName != null ? this.superOperationName + "Persistence" : (this.profile.getPersistenceInterface() != null ? this.profile.getPersistenceInterface() : "PersistentOperation");
        return superPersistenceInterface;
    }

    public String getSuperDomainImplementation() {
        Object superDomainImplementation = this.superOperationName != null ? this.superOperationName + "DomainImpl" : (this.profile.getDomainImplementation() != null ? this.profile.getDomainImplementation() : "AbstractDomainOperation");
        return superDomainImplementation;
    }

    public String getSuperPersistenceImplementation() {
        Object superPersistenceImplementation = this.superOperationName != null ? this.superOperationName + "PersistenceImpl" : (this.profile.getPersistenceImplementation() != null ? this.profile.getPersistenceImplementation() : "AbstractPersistentOperation");
        return superPersistenceImplementation;
    }
}

