/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.tentackle.maven.plugin.wizard.PackageInfo;
import org.tentackle.maven.plugin.wizard.Profile;
import org.tentackle.model.EntityAliases;
import org.tentackle.model.Model;
import org.tentackle.model.ModelDefaults;
import org.tentackle.model.ModelException;

public abstract class AbstractWizardMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.directory}/wurbel/model", property="tentackle.modelDir")
    protected File modelDir;
    @Parameter(defaultValue="${project.build.directory}/wizard")
    private File statusDir;
    @Parameter(property="tentackle.modelDefaults")
    protected String modelDefaults;
    @Parameter(property="tentackle.entityAliases")
    protected String entityAliases;
    @Parameter
    protected List<FileSet> filesets;
    @Parameter(required=true)
    private List<Profile> profiles;
    @Parameter(defaultValue="${project.basedir}/templates")
    private File templateDir;

    public <T extends Profile> List<T> getProfiles(Class<T> clazz) throws MojoExecutionException {
        ArrayList<Profile> list = new ArrayList<Profile>();
        for (Profile profile : this.profiles) {
            if (!clazz.isAssignableFrom(profile.getClass())) continue;
            if (list.contains(profile)) {
                throw new MojoExecutionException("profile " + profile + " configured more than once");
            }
            list.add(profile);
        }
        return list;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public File getStatusDir() {
        return this.statusDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validate();
        this.loadModel();
    }

    protected ModelDefaults getModelDefaults() throws MojoExecutionException {
        if (this.modelDefaults == null) {
            return null;
        }
        try {
            return new ModelDefaults(this.modelDefaults);
        }
        catch (ModelException mex) {
            throw new MojoExecutionException(mex.getMessage(), (Exception)((Object)mex));
        }
    }

    protected EntityAliases getEntityAliases() throws MojoExecutionException {
        if (this.entityAliases == null) {
            return null;
        }
        try {
            return new EntityAliases(this.entityAliases);
        }
        catch (ModelException mex) {
            throw new MojoExecutionException(mex.getMessage(), (Exception)((Object)mex));
        }
    }

    protected void loadModel() throws MojoFailureException, MojoExecutionException {
        int errors = 0;
        if (this.filesets != null && !this.filesets.isEmpty()) {
            for (FileSet fileSet : this.filesets) {
                errors += this.processFileSet(fileSet);
            }
        } else {
            String[] files;
            String[] stringArray = files = this.modelDir.isDirectory() ? this.modelDir.list() : null;
            if (files != null && files.length > 0) {
                FileSet fs = new FileSet();
                fs.setDirectory(this.modelDir.getPath());
                errors += this.processFileSet(fs);
            } else {
                this.getLog().warn((CharSequence)((this.modelDir.exists() ? "empty modelDir " : "no modelDir ") + this.modelDir.getAbsolutePath()));
            }
        }
        if (errors > 0) {
            throw new MojoFailureException(errors + " model errors");
        }
        try {
            this.getLog().info((CharSequence)(Model.getInstance().getAllEntitites().size() + " entities loaded"));
        }
        catch (ModelException e) {
            throw new MojoExecutionException("cannot determine entities", (Exception)((Object)e));
        }
    }

    protected int processFileSet(FileSet fileSet) throws MojoExecutionException {
        int errors = 0;
        if (fileSet.getDirectory() == null) {
            fileSet.setDirectory(this.modelDir.getAbsolutePath());
        }
        File dir = new File(fileSet.getDirectory());
        String modelDirName = dir.getPath();
        try {
            Model.getInstance().loadModel(modelDirName, this.getModelDefaults(), this.getEntityAliases());
        }
        catch (ModelException mex) {
            this.getLog().error((CharSequence)("parsing model failed in directory " + modelDirName + ":\n" + mex.getMessage()));
            ++errors;
        }
        return errors;
    }

    protected void validate() throws MojoExecutionException {
        if (this.mavenProject == null) {
            throw new MojoExecutionException("missing project");
        }
        if (this.mavenProject.getBasedir() == null) {
            throw new MojoExecutionException("missing project.baseDir");
        }
        if (this.templateDir.exists()) {
            if (!this.templateDir.isDirectory()) {
                throw new MojoExecutionException(this.templateDir.getPath() + " is not a directory");
            }
        } else {
            this.templateDir.mkdirs();
            this.getLog().info((CharSequence)("template directory created: " + this.templateDir.getPath()));
            this.installTemplates();
        }
    }

    protected void installTemplates() throws MojoExecutionException {
        this.installTemplate("pdo", "DomainImplementation.ftl");
        this.installTemplate("pdo", "DomainInterface.ftl");
        this.installTemplate("pdo", "PdoInterface.ftl");
        this.installTemplate("pdo", "PersistenceImplementation.ftl");
        this.installTemplate("pdo", "PersistenceInterface.ftl");
        this.installTemplate("operation", "DomainImplementation.ftl");
        this.installTemplate("operation", "DomainInterface.ftl");
        this.installTemplate("operation", "OperationInterface.ftl");
        this.installTemplate("operation", "PersistenceImplementation.ftl");
        this.installTemplate("operation", "PersistenceInterface.ftl");
    }

    private void installTemplate(String category, String template) throws MojoExecutionException {
        File dir = new File(this.templateDir, category);
        dir.mkdirs();
        File file = new File(dir, template);
        String path = "/templates/" + category + "/" + template;
        String text = this.loadResourceFileIntoString(path);
        try (PrintStream ps = new PrintStream(new FileOutputStream(file));){
            ps.print(text);
            this.getLog().info((CharSequence)("installed " + category + "-template " + template));
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot install template " + path, (Exception)e);
        }
    }

    private String loadResourceFileIntoString(String path) throws MojoExecutionException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (inputStream == null) {
            throw new MojoExecutionException("no such resource: " + path);
        }
        BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
        return buffer.lines().collect(Collectors.joining(System.getProperty("line.separator")));
    }

    protected Map<String, PackageInfo> createPackageMap() throws MojoExecutionException {
        HashMap<String, PackageInfo> map = new HashMap<String, PackageInfo>();
        StringBuilder buf = new StringBuilder();
        for (MavenProject project : this.mavenProject.getCollectedProjects()) {
            for (String path : project.getCompileSourceRoots()) {
                for (PackageInfo info : this.getPackages(project, path)) {
                    boolean infoContaingFiles = info.isContainingJavaFiles();
                    PackageInfo splitPkg = (PackageInfo)map.get(info.getName());
                    if (splitPkg != null) {
                        if (splitPkg.isContainingJavaFiles()) {
                            if (!infoContaingFiles) continue;
                            buf.append("\nsplit package detected: ").append(info.getName()).append(" in ").append(project.getName()).append(" and ").append(splitPkg.getProject().getName());
                            continue;
                        }
                        if (!infoContaingFiles) {
                            List<PackageInfo> dups = splitPkg.getEmptyDuplicates();
                            if (dups == null) {
                                dups = new ArrayList<PackageInfo>();
                                splitPkg.setEmptyDuplicates(dups);
                            }
                            dups.add(info);
                            continue;
                        }
                    }
                    map.put(info.getName(), info);
                }
            }
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(0);
            throw new MojoExecutionException(buf.toString());
        }
        return map;
    }

    private List<PackageInfo> getPackages(MavenProject project, String compileSourceRoot) {
        ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
        this.checkDir(project, new File(compileSourceRoot), packages, "");
        return packages;
    }

    private void checkDir(MavenProject project, File dir, List<PackageInfo> packages, String packageName) {
        if (dir.isDirectory()) {
            boolean containsJavaFiles = false;
            boolean empty = true;
            for (File file : dir.listFiles()) {
                if (file.isHidden()) continue;
                empty = false;
                if (file.isDirectory()) {
                    this.checkDir(project, file, packages, (String)(packageName.isEmpty() ? file.getName() : packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".java")) continue;
                containsJavaFiles = true;
            }
            if ((empty || containsJavaFiles) && !packageName.isEmpty()) {
                packages.add(new PackageInfo(packageName, project, dir));
            }
        }
    }
}

