/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import org.tentackle.common.Service;
import org.tentackle.sql.AbstractSql2003Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;

@Service(value=Backend.class)
public class Ingres
extends AbstractSql2003Backend {
    public static final String SQL_FIRST = "FIRST ";
    public static final String SQL_FIRST_PAR = "FIRST ? ";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":ingres");
    }

    @Override
    public String getName() {
        return "Ingres";
    }

    @Override
    public String getDriverClassName() {
        return "com.ingres.jdbc.IngresDriver";
    }

    @Override
    public String getBackendId(Connection connection) {
        return null;
    }

    @Override
    public boolean sqlRequiresExtraCommit() {
        return true;
    }

    @Override
    public boolean needSetLongWorkaround() {
        return true;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (limit > 0 && offset <= 0) {
            sqlBuilder.insert(0, SQL_FIRST_PAR);
            sqlBuilder.insert(0, "SELECT ");
        } else {
            super.buildSelectSql(sqlBuilder, writeLock, limit, offset);
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        int index = 1;
        if (limit > 0 && offset <= 0) {
            stmt.setInt(index++, limit);
        }
        return index;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (limit > 0 && offset <= 0) {
            return index;
        }
        return super.setTrailingSelectParameters(stmt, index, limit, offset);
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 38;
            }
            case VARCHAR: {
                return 1024;
            }
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "TINYINT";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "FLOAT4";
            }
            case DOUBLE: {
                return "FLOAT";
            }
            case DECIMAL: {
                return "NUMBER";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "DATE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case LONGVARBINARY: {
                return "BLOB";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 16: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT};
            }
            case 91: 
            case 92: {
                return new SqlType[]{SqlType.DATE, SqlType.TIME};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = sql.indexOf(SQL_FIRST);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with FIRST");
        }
        return super.extractWhereClause(sql, whereOffset);
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }
}

