/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.tentackle.common.Service;
import org.tentackle.sql.AbstractSql92Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.SqlType;

@Service(value=Backend.class)
public class Informix
extends AbstractSql92Backend {
    public static final String SQL_NVL = "NVL";
    public static final String SQL_FIRST = "FIRST ";
    public static final String SQL_SKIP = "SKIP ";
    public static final String SQL_FIRST_PAR = "FIRST ? ";
    public static final String SQL_SKIP_PAR = "SKIP ? ";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":informix");
    }

    @Override
    public String getName() {
        return "Informix";
    }

    @Override
    public String getDriverClassName() {
        return "com.informix.jdbc.IfxDriver";
    }

    @Override
    public String getBackendId(Connection connection) {
        return null;
    }

    @Override
    public Connection createConnection(String url, String username, char[] password) throws SQLException {
        return DriverManager.getConnection(url + ";user=" + username + ";password=" + this.createPassword(password));
    }

    @Override
    public String getCoalesceKeyword() {
        return SQL_NVL;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (limit > 0) {
            sqlBuilder.insert(0, SQL_FIRST_PAR);
        }
        if (offset > 0) {
            sqlBuilder.insert(0, SQL_SKIP_PAR);
        }
        sqlBuilder.insert(0, "SELECT ");
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        int index = 1;
        if (offset > 0) {
            stmt.setInt(index++, offset);
        }
        if (limit > 0) {
            stmt.setInt(index++, limit);
        }
        return index;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        return index;
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 31;
            }
            case VARCHAR: {
                return 255;
            }
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "BOOLEAN";
            }
            case TINYINT: {
                return "SMALLINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INT";
            }
            case BIGINT: {
                return "INT8";
            }
            case FLOAT: {
                return "SMALLFLOAT";
            }
            case DOUBLE: {
                return "FLOAT";
            }
            case DECIMAL: {
                return "NUMBER";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "DATETIME";
            }
            case TIMESTAMP: {
                return "DATETIME YEAR TO SECOND";
            }
            case LONGVARBINARY: {
                return "BYTE";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -6: 
            case 5: {
                return new SqlType[]{SqlType.TINYINT, SqlType.SMALLINT};
            }
            case 92: 
            case 93: {
                return new SqlType[]{SqlType.TIME, SqlType.TIMESTAMP};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String sqlNextFromSequene(String name) {
        return "SELECT " + name + ".NEXTVAL";
    }

    @Override
    public String sqlRenameColumn(String tableName, String oldColumnName, String newColumnName) {
        return "RENAME COLUMN " + tableName + "." + oldColumnName + " TO " + newColumnName + ";\n";
    }

    @Override
    public String sqlRenameIndex(String tableName, String oldIndexName, String newIndexName) {
        return "RENAME INDEX " + oldIndexName + " TO " + newIndexName + ";\n";
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlDropColumn(String tableName, String columnName) {
        return "ALTER TABLE " + tableName + " DROP (" + columnName + ");\n";
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " MODIFY (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnDefault(String tableName, String columnName, SqlType sqlType, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" MODIFY (");
        buf.append(columnName);
        buf.append(" ");
        if (defaultValue == null) {
            buf.append("DROP DEFAULT");
        } else {
            buf.append("SET DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        buf.append(");\n");
        return buf.toString();
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = sql.indexOf(SQL_FIRST);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with FIRST");
        }
        ndx = sql.indexOf(SQL_SKIP);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with SKIP");
        }
        return super.extractWhereClause(sql, whereOffset);
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }
}

