/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendFactory;
import org.tentackle.sql.DynamicDriver;

public class BackendInfo {
    private final Backend backend;
    private final DataSource jndiDataSource;
    private final String url;
    private final String user;
    private final char[] password;
    private final String[] schemas;

    public BackendInfo(Backend backend) {
        this.backend = backend;
        this.url = null;
        this.user = null;
        this.password = null;
        this.jndiDataSource = null;
        this.schemas = null;
    }

    public BackendInfo(String backendName) {
        this(BackendFactory.getInstance().getBackendByName(backendName));
    }

    public BackendInfo(String url, String user, char[] password, String[] schemas) {
        if (url == null || url.isEmpty()) {
            throw new BackendException("url missing");
        }
        this.url = url;
        this.user = user;
        this.password = password;
        this.schemas = schemas;
        if (url.startsWith("jndi:")) {
            int cndx = url.lastIndexOf(58);
            String jndiName = cndx < 6 ? url.substring(5) : url.substring(5, cndx);
            try {
                this.jndiDataSource = (DataSource)new InitialContext().lookup(jndiName);
            }
            catch (NamingException nex) {
                throw new BackendException("lookup failed for " + jndiName, nex);
            }
            if (cndx < 6) {
                Connection tempCon = null;
                try {
                    tempCon = this.jndiDataSource.getConnection();
                    DatabaseMetaData metaData = tempCon.getMetaData();
                    if (metaData == null) {
                        throw new BackendException("Metadata of JNDI-connection cannot be determined. Please add the backend type: " + url + ":<backend-type>");
                    }
                    String jndiURL = metaData.getURL();
                    if (jndiURL == null) {
                        throw new BackendException("URL of JNDI-connection cannot be determined. Please add the backend type: " + url + ":<backend-type>");
                    }
                    this.backend = BackendFactory.getInstance().getBackendByUrl(jndiURL);
                }
                catch (SQLException sqx) {
                    throw new BackendException("cannot retrieve metadata of JNDI source " + jndiName, sqx);
                }
                finally {
                    if (tempCon != null) {
                        try {
                            tempCon.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            this.backend = BackendFactory.getInstance().getBackendByUrl(url);
        } else if (url.startsWith("rmi:")) {
            this.backend = null;
            this.jndiDataSource = null;
        } else {
            this.backend = BackendFactory.getInstance().getBackendByUrl(url);
            this.jndiDataSource = null;
        }
    }

    public BackendInfo(Properties backendProperties) {
        this(backendProperties.getProperty("url"), backendProperties.getProperty("user"), BackendInfo.parsePassword(backendProperties.getProperty("password")), BackendInfo.parseSchemas(backendProperties.getProperty("schemas")));
        String driver = backendProperties.getProperty("driver");
        if (driver != null) {
            DynamicDriver.load(driver);
        }
    }

    public Backend getBackend() {
        return this.backend;
    }

    public boolean isRemote() {
        return this.backend == null;
    }

    public DataSource getJndiDataSource() {
        return this.jndiDataSource;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void clearPassword() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
        }
    }

    public String[] getSchemas() {
        return this.schemas;
    }

    public boolean isConnectable() {
        return this.url != null;
    }

    public Connection connect() throws SQLException {
        Connection connection = this.jndiDataSource != null ? this.jndiDataSource.getConnection() : this.backend.createConnection(this.url, this.user, this.password);
        try {
            if (!connection.getAutoCommit()) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException sqx) {
            connection.close();
            throw sqx;
        }
        return connection;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isRemote()) {
            buf.append("remote");
        } else {
            buf.append(this.backend);
        }
        if (this.url != null) {
            buf.append('@');
            buf.append(this.url);
        }
        return buf.toString();
    }

    private static String[] parseSchemas(String str) {
        StringTokenizer stok;
        int count;
        String[] schemas = null;
        if (str != null && (count = (stok = new StringTokenizer(str, ",")).countTokens()) > 0) {
            schemas = new String[count];
            for (int i = 0; i < count; ++i) {
                schemas[i] = stok.nextToken().trim();
            }
        }
        return schemas;
    }

    private static char[] parsePassword(String str) {
        char[] password = null;
        if (str != null) {
            password = str.toCharArray();
        }
        return password;
    }
}

