/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.metadata.IndexMetaData;

public class IndexColumnMetaData
implements Comparable<IndexColumnMetaData> {
    private final IndexMetaData indexMetaData;
    private String columnName;
    private String functionName;
    private boolean descending;
    private int position;

    public IndexColumnMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public void setupIndexColumnFromMetaData(ResultSet resultSet) throws SQLException {
        String ascDesc;
        int ndx2;
        this.columnName = StringHelper.toLower((String)resultSet.getString("COLUMN_NAME"));
        int ndx1 = this.columnName.indexOf(40);
        if (ndx1 >= 0 && (ndx2 = this.columnName.lastIndexOf(41)) > ndx1) {
            this.functionName = this.columnName.substring(0, ndx1).trim().toUpperCase(Locale.ROOT);
            this.columnName = this.columnName.substring(ndx1 + 1, ndx2).trim().toLowerCase(Locale.ROOT);
        }
        this.descending = (ascDesc = resultSet.getString("ASC_OR_DESC")) != null && ascDesc.startsWith("D");
        this.position = resultSet.getShort("ORDINAL_POSITION");
        this.validate();
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public int compareTo(IndexColumnMetaData o) {
        return this.position - o.position;
    }

    public void validate() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.columnName);
        if (this.descending) {
            buf.append(" DESC");
        }
        return buf.toString();
    }
}

