/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.metadata.ForeignKeyAction;
import org.tentackle.sql.metadata.ForeignKeyMetaData;

public class ForeignKeyColumnMetaData
implements Comparable<ForeignKeyColumnMetaData> {
    private final ForeignKeyMetaData foreignKeyMetaData;
    private int position;
    private String foreignKeyColumn;
    private String primaryKeyColumn;

    public ForeignKeyColumnMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public void setForeignKeyColumn(String foreignKeyColumn) {
        this.foreignKeyColumn = foreignKeyColumn;
    }

    public String getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public void setupForeignKeyColumnFromMetaData(ResultSet resultSet) throws SQLException {
        String defaultSchema = this.getForeignKeyMetaData().getTableMetaData().getModelMetaData().getBackend().getDefaultSchema();
        this.position = resultSet.getShort("KEY_SEQ");
        this.foreignKeyColumn = StringHelper.toLower((String)resultSet.getString("FKCOLUMN_NAME"));
        this.primaryKeyColumn = StringHelper.toLower((String)resultSet.getString("PKCOLUMN_NAME"));
        String val = StringHelper.toLower((String)resultSet.getString("FKTABLE_SCHEM"));
        if (defaultSchema != null && defaultSchema.equals(val)) {
            val = null;
        }
        if (!Objects.equals(val, this.foreignKeyMetaData.getForeignKeySchema())) {
            throw new BackendException("inconsistent referencing schema in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + String.valueOf(this) + ", found " + val + ", expected " + this.foreignKeyMetaData.getForeignKeySchema());
        }
        val = StringHelper.toLower((String)resultSet.getString("FKTABLE_NAME"));
        if (!Objects.equals(val, this.foreignKeyMetaData.getForeignKeyTable())) {
            throw new BackendException("inconsistent referencing table in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + String.valueOf(this) + ", found " + val + ", expected " + this.foreignKeyMetaData.getForeignKeyTable());
        }
        val = StringHelper.toLower((String)resultSet.getString("PKTABLE_SCHEM"));
        if (defaultSchema != null && defaultSchema.equals(val)) {
            val = null;
        }
        if (!Objects.equals(val, this.foreignKeyMetaData.getPrimaryKeySchema())) {
            throw new BackendException("inconsistent referenced schema in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + String.valueOf(this) + ", found " + val + ", expected " + this.foreignKeyMetaData.getPrimaryKeySchema());
        }
        val = StringHelper.toLower((String)resultSet.getString("PKTABLE_NAME"));
        if (!Objects.equals(val, this.foreignKeyMetaData.getPrimaryKeyTable())) {
            throw new BackendException("inconsistent referenced table in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + String.valueOf(this) + ", found " + val + ", expected " + this.foreignKeyMetaData.getPrimaryKeyTable());
        }
        ForeignKeyAction action = ForeignKeyAction.createFromAction(resultSet.getShort("UPDATE_RULE"));
        if (!Objects.equals((Object)action, (Object)this.foreignKeyMetaData.getUpdateRule())) {
            throw new BackendException("inconsistent update rule in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + String.valueOf(this) + ", found " + String.valueOf((Object)action) + ", expected " + String.valueOf((Object)this.foreignKeyMetaData.getUpdateRule()));
        }
        action = ForeignKeyAction.createFromAction(resultSet.getShort("DELETE_RULE"));
        if (!Objects.equals((Object)action, (Object)this.foreignKeyMetaData.getDeleteRule())) {
            throw new BackendException("inconsistent delete rule in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + String.valueOf(this) + ", found " + String.valueOf((Object)action) + ", expected " + String.valueOf((Object)this.foreignKeyMetaData.getDeleteRule()));
        }
    }

    @Override
    public int compareTo(ForeignKeyColumnMetaData o) {
        return this.position - o.position;
    }

    public String toString() {
        return this.foreignKeyColumn;
    }
}

