/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;

@Service(value=DataType.class)
public final class UUIDType
extends AbstractDataType<UUID> {
    public static final UUID NIL = new UUID(0L, 0L);
    public static final String NIL_STR = NIL.toString();
    private static final int VARCHAR_LEN = 36;

    @Override
    public String getJavaType() {
        return "UUID";
    }

    @Override
    public int[] getSortableColumns() {
        return null;
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public UUID getMappedNullValue(Backend backend, int index) {
        return NIL;
    }

    @Override
    public boolean isPredefined() {
        return false;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (backend.isUUIDSupported()) {
            return SqlType.UUID;
        }
        return SqlType.VARCHAR;
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        if (backend.isUUIDSupported()) {
            return super.getSize(backend, index, size);
        }
        return 36;
    }

    @Override
    public UUID valueOf(String str) {
        return UUID.fromString(str);
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (!((String)str).isEmpty() && ((String)str).charAt(0) != '\"') {
            str = "\"" + (String)str + "\"";
        }
        return "UUID.fromString(" + (String)str + ")";
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, UUID object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = NIL;
        }
        if (backend.isUUIDSupported()) {
            if (object == null) {
                statement.setNull(pos, 2000);
            } else {
                statement.setObject(pos, object);
            }
        } else if (object == null) {
            statement.setNull(pos, 12);
        } else {
            statement.setString(pos, object.toString());
        }
        return new Object[]{object};
    }

    @Override
    public UUID get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        UUID uuid;
        if (backend.isUUIDSupported()) {
            uuid = (UUID)resultSet.getObject(pos[0]);
            if (mapNull && NIL.equals(uuid)) {
                return null;
            }
        } else {
            String str = resultSet.getString(pos[0]);
            if (mapNull && NIL_STR.equals(str)) {
                return null;
            }
            uuid = str == null || str.isEmpty() ? null : UUID.fromString(str);
        }
        return uuid;
    }
}

