/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class TimeType
extends AbstractDateTimeType<Time> {
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    public boolean isTimezoneApplicable() {
        return true;
    }

    @Override
    public String getJavaType() {
        return "Time";
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIME;
    }

    @Override
    public Time valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(Time object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Time object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 92);
        } else {
            statement.setTime(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Time get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Time time = resultSet.getTime(pos[0]);
        return time == null ? null : org.tentackle.common.Time.createFrozen((long)time.getTime());
    }

    protected Time parse(String str) throws BackendException {
        try {
            return Time.valueOf(TIME_FORMAT.parse((CharSequence)StringHelper.parseString((String)str), LocalTime::from));
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing time from '" + str + "' failed", e);
        }
    }

    protected String format(Time time) {
        return TIME_FORMAT.format(time.toLocalTime());
    }
}

