/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;
import org.tentackle.sql.datatypes.LargeStringType;

@Service(value=DataType.class)
public sealed class StringType
extends AbstractDataType<String>
permits LargeStringType {
    @Override
    public String getJavaType() {
        return "String";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public Object getMappedNullValue(Backend backend, int index) {
        if (backend == null) {
            throw new BackendException("MAPNULL value is backend-specific for " + String.valueOf(this));
        }
        return backend.getEmptyString();
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.VARCHAR;
    }

    @Override
    public String valueOf(String str) {
        return StringHelper.parseString((String)str);
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        return this.valueStringToCode(str);
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, String object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = backend.getEmptyString();
        }
        if (object == null) {
            statement.setNull(pos, 12);
        } else {
            statement.setString(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public String get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        String str = resultSet.getString(pos[0]);
        if (mapNull && str != null && str.equals(backend.getEmptyString())) {
            return null;
        }
        return str;
    }
}

